% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressions.R, R/exports.R
\docType{methods}
\name{^,Expression,numeric-method}
\alias{^,Expression,numeric-method}
\alias{power}
\alias{^}
\title{Elementwise Power}
\usage{
\S4method{^}{Expression,numeric}(e1, e2)

power(x, p, max_denom = 1024)
}
\arguments{
\item{e1}{An \linkS4class{Expression} object to exponentiate.}

\item{e2}{The power of the exponential. Must be a numeric scalar.}

\item{x}{An \linkS4class{Expression}, vector, or matrix.}

\item{p}{A scalar value indicating the exponential power.}

\item{max_denom}{The maximum denominator considered in forming a rational approximation of \code{p}.}
}
\description{
Raises each element of the input to the power \eqn{p}.
If \code{expr} is a CVXR expression, then \code{expr^p} is equivalent to \code{power(expr,p)}.
}
\details{
For \eqn{p = 0} and \eqn{f(x) = 1}, this function is constant and positive.
For \eqn{p = 1} and \eqn{f(x) = x}, this function is affine, increasing, and the same sign as \eqn{x}.
For \eqn{p = 2,4,8,\ldots} and \eqn{f(x) = |x|^p}, this function is convex, positive, with signed monotonicity.
For \eqn{p < 0} and \eqn{f(x) = }
\itemize{
  \item{\eqn{x^p}}{ for \eqn{x > 0}}
  \item{\eqn{+\infty}}{\eqn{x \leq 0}}
}, this function is convex, decreasing, and positive.
For \eqn{0 < p < 1} and \eqn{f(x) =}
\itemize{
  \item{\eqn{x^p}}{ for \eqn{x \geq 0}}
  \item{\eqn{-\infty}}{\eqn{x < 0}}
}, this function is concave, increasing, and positivea.
For \eqn{p > 1, p \neq 2,4,8,\ldots} and \eqn{f(x) = }
\itemize{
  \item{\eqn{x^p}}{ for \eqn{x \geq 0}}
  \item{\eqn{+\infty}}{\eqn{x < 0}}
}, this function is convex, increasing, and positive.
}
\examples{
\dontrun{
x <- Variable()
prob <- Problem(Minimize(power(x,1.7) + power(x,-2.3) - power(x,0.45)))
result <- solve(prob)
result$value
result$getValue(x)
}
}
