# @title Auxiliary function for the log-likelihood estimation of CUBE models with covariates
# @aliases Quno
# @description Define the opposite one of the two scalar functions that are maximized when running the E-M algorithm
#  for CUBE models with covariates for feeling, uncertainty and overdispersion.
# @usage Quno(bet, esterno1)
# @param bet Vector of initial estimates of parameters for the uncertainty component
# @param esterno1  Matrix binding together the column vector of the posterior probabilities
# that each observed rating has been generated by the first component distribution of the mixture, with the matrix 
# YY of explicative  variables for the uncertainty component, expanded with a unitary vector in the first column to 
# consider also an intercept term
# @details It is iteratively called as an argument of "optim" within CUBE function (with covariates) as  the function
#  to minimize  to compute the maximum likelihood estimates for the feeling and the overdispersion components. 
#' @keywords internal 


Quno <-
function(bet,esterno1){
  tauno<-esterno1[,1]
  covar<-esterno1[,2:ncol(esterno1)]
  ybeta<-covar%*%bet;
  return(-sum(tauno*ybeta-log(1+exp(ybeta)))) ### change sign for optim
}
