% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_AdamontQQCorr.R
\name{AdamontQQCorr}
\alias{AdamontQQCorr}
\title{AdamontQQCorr computes quantile-quantile correction of seasonal or decadal
forecast data using weather types}
\usage{
AdamontQQCorr(
  exp,
  wt_exp,
  obs,
  wt_obs,
  corrdims = c("member", "sdate", "ftime"),
  londim = "lon",
  latdim = "lat",
  regrid = FALSE,
  NN = NULL
)
}
\arguments{
\item{exp}{array with named dimensions (such as \code{$data} array of 
experiment data from an object of class \code{s2dv_cube})}

\item{wt_exp}{corresponding weather types (same dimensions as \code{exp} but
lat/lon)}

\item{obs}{array with named dimensions with reference data (can also be 
\code{$data} array of class \code{s2dv_cube}). lat/lon dimensions can differ 
from \code{exp} if non rectilinear latlon grids are used, in which case 
regrid should be set to TRUE and .NearestNeighbors \code{NN} output should be
provided}

\item{wt_obs}{corresponding weather types (same dimensions as \code{obs} but
lat/lon)}

\item{corrdims}{list of dimensions in \code{exp} for which quantile mapping 
correction is applied}

\item{londim}{character name of longitude dimension in \code{exp} and 
\code{obs}}

\item{latdim}{character name of latitude dimension in \code{exp} and 
\code{obs}}

\item{regrid}{(optional) boolean indicating whether .NearestNeighbors
regridding is needed}

\item{NN}{(optional, if regrid=TRUE) list (output from .NearestNeighbors)
maps (nlat, nlon) onto (nlat_o, nlon_o)}
}
\value{
an array (such as \code{$data} array from an object of class 
\code{s2dv_cube}) with named dimensions, containing experiment data on the 
lat/lon grid of \code{obs} array, corrected by quantile mapping depending on 
the weather types \code{wt_exp}
}
\description{
This function computes a quantile mapping based on weather types
for experiment data (typically a hindcast) onto reference \code{obs},
typically provided by reanalysis data.
}
\examples{
\dontrun{
wt_exp <- sample(1:3, 15*6*3, replace=T)
dim(wt_exp) <- c(dataset=1, member=15, sdate=6, ftime=3)
wt_obs <- sample(1:3, 6*3, replace=T)
dim(wt_obs) <- c(dataset=1, member=1, sdate=6, ftime=3)
exp_corr <- AdamontQQCorr(exp=lonlat_data$exp$data, wt_exp=wt_exp, 
   obs=lonlat_data$obs$data, wt_obs=wt_obs, 
   corrdims = c('dataset','member','sdate','ftime'))
}
}
\author{
Paola Marson, \email{paola.marson@meteo.fr} for PROSNOW version

Lauriane Batté, \email{lauriane.batte@meteo.fr} for CSTools adaptation
}
