% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSESA.R
\name{CSESA}
\alias{CSESA}
\title{CSESA (CRISPR-based Salmonella enterica Serotype Analyzer).}
\usage{
CSESA(in.file1 = NULL, in.file2 = NULL, out.file = NULL,
  method = c("PCR", "WGS"))
}
\arguments{
\item{in.file1}{The first input file, the default value is NULL.}

\item{in.file2}{The second input file (optional), the default value is NULL.}

\item{out.file}{Into which results will be saved if this value is set. Otherwise results will be displayed on the screen.}

\item{method}{The method to handle the input file(s), which can be set as "PCR" or "WGS". Choose "PCR" if the CRISPR sequence(s) from PCR amplification is entered, and choose "WGS" when entering the whole genome assembly of a Salmonella isolate.}
}
\description{
The main function in CSESA package.
}
\note{
If you use the "WGS" method, please make sure you have installed the BLAST software and included it within the working path.
}
\examples{
  CSESA(system.file("extdata", "sequence_CRIPSR1.fasta", package = "CSESA"), 
  system.file("extdata", "sequence_CRIPSR2.fasta", package = "CSESA"), method = "PCR")
  CSESA(system.file("extdata", "sequence_CRIPSR1.fasta", package = "CSESA"), method = "PCR")
  CSESA(system.file("extdata", "Salmonella_whole_genome_assembly.fasta", 
  package = "CSESA"), method = "WGS")
}
