% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{readFile}
\alias{readFile}
\title{Reads experimental data from a file.
This function reads the data from specified (excel,log, txt etc) file and store it in a data frame.}
\usage{
readFile(filename, separator, sheet, noofrows_skip, readplates,
  numberofrowsperplate, platetype)
}
\arguments{
\item{filename}{Filename.ext.}

\item{separator}{Any character(, ; ' etc) that is used as a separator in specified file.}

\item{sheet}{Need to use only when reading excel files. It is the number of the excel sheet to be read in a worksheet.}

\item{noofrows_skip}{Number of the rows in the file that should be skipped before starting the data reading.}

\item{readplates}{Number of the plates that you want to read from a set of plates in a file.This parameter can only 
be used with excel files. Otherwise it will be ignored.}

\item{numberofrowsperplate}{It is calculated on the basis of type of plates i-e number of rows per plates are 17 for 
384 well plates(16 lines from plates + 1 header lines) and 9 for 96 well plates (8 lines from plates + 1 header lines).}

\item{platetype}{type of plate used i-e 384 or 96 well plate.}
}
\value{
Data frame of file data.
}
\description{
Reads experimental data from a file.
This function reads the data from specified (excel,log, txt etc) file and store it in a data frame.
}
\examples{
f <- system.file("extdata", "optima.log", package="COMBIA")
fileDF <- readFile(filename = f, separator ="\\t", sheet=1, noofrows_skip=0,   
readplates=1, numberofrowsperplate=17, platetype="384")  
}
\author{
Muhammad Kashif
}
