% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freadGDCfile.R
\name{freadGDCfile}
\alias{freadGDCfile}
\title{Read GDC segmentation datafile for low-pass sequencing data.}
\usage{
freadGDCfile(file, fread_skip = 14)
}
\arguments{
\item{file}{GDC file to be read}

\item{fread_skip}{The number of metadata lines to be skipped(typically 14)..}
}
\value{
input_tsv_with_sample_info A data frame containing the sample information extracted
 from the filename, including sample name & comparison type.
}
\description{
Reads a GDC segmetnation file and extract the segmetnation data.
}
\examples{
freadGDCfile(file =
system.file("extdata","somaticCnvSegmentsDiploidBeta_TARGET-30-PANRVJ_NormalVsPrimary.tsv",
package = "CNVScope"))
}
\keyword{file}
\keyword{read}
