% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_transformers.R
\name{network_cof_transformers}
\alias{network_cof_transformers}
\title{Network cost of Failure for Transformers}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
network_cof_transformers(tf_asset_category, actual_load_mva, secure = T)
}
\arguments{
\item{tf_asset_category}{String The type of Transformer asset category
Options: \code{tf_asset_category = c("6.6/11kV Transformer (GM)",
"20kV Transformer (GM)", "33kV Transformer (GM)", "66kV Transformer (GM) "
"132kV Transformer (GM) ")}.}

\item{actual_load_mva}{Numeric. The actual load on the asset}

\item{secure}{Boolean If the asset is in a secure network or not}
}
\value{
Numeric. Network cost of failure.
}
\description{
This function calculates network cost of failure for
all asset categories exclusive the assets EHV and 132kV transformers.
(cf. section 7.6, page 87, CNAIM, 2021). Network cost of failure
is used in the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
network_cof_transformers(tf_asset_category = "33kV Transformer (GM)",
actual_load_mva = 15)
}
