% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof_future_submarine_cables.R
\name{pof_future_submarine_cables}
\alias{pof_future_submarine_cables}
\title{Future Probability of Failure for Submarine Cables}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
pof_future_submarine_cables(
  sub_cable_type = "EHV Sub Cable",
  utilisation_pct = "Default",
  operating_voltage_pct = "Default",
  topography = "Default",
  sitution = "Default",
  wind_wave = "Default",
  intensity = "Default",
  landlocked = "no",
  sheath_test = "Default",
  partial_discharge = "Default",
  fault_hist = "Default",
  condition_armour = "Default",
  age,
  reliability_factor = "Default",
  simulation_end_year = 100
)
}
\arguments{
\item{sub_cable_type}{String.
A sting that refers to the specific asset category.
See See page 15, table 1 in CNAIM (2017).
Options:
\code{sub_cable_type =
c("HV Sub Cable", "EHV Sub Cable", "132kV Sub Cable")}.
The deafult setting is \code{sub_cable_type = "EHV Sub Cable"}.}

\item{utilisation_pct}{Numeric. The max percentage of utilisation
under normal operating conditions.}

\item{operating_voltage_pct}{Numeric. The ratio in percent of
operating/design voltage.}

\item{topography}{String. Describe the topography around the submarine cable.
Options:
\code{typography = c("Low Detrimental Topography",
"Medium Detrimental Topography", "High Detrimental Topography",
"Very High Detrimental Topography","Default" )}}

\item{sitution}{String. Descibes how the submarine cable af fixed to the
sea floor.
Options:
\code{sitution=c("Laid on bed", "Covered", "Buried", "Default")}}

\item{wind_wave}{Numeric.
Options:
\code{wind_wave=c(1, 2, 3, "Default")}.
Settings:
\itemize{
\item{\code{wind_wave = 1}:} Sheltered sea loch, Wind <200 W/m2
\item{\code{wind_wave = 2}:} Wave <15kW/m, Wind 200-800 W/m2
\item{\code{wind_wave = 3}:} Wave <15kW/m, Wind 200-800 W/m2
\item{\code{wind_wave = "Default"}:} No data available
}}

\item{intensity}{String. Combined wave and current energy factor.
Options:
\code{intensity=c("Low", "Moderate", "High", "Default")}.}

\item{landlocked}{String. Options: \code{landlocked = c("yes","no")}. Default
setting for \code{landlocked = "no"}.}

\item{sheath_test}{String. Indicating the state of the sheath. Options:
\code{sheath_test = c("Pass", "Failed Minor", "Failed Major",
"Default")}. See page 143, table 182 in CNAIM (2017).}

\item{partial_discharge}{String. Indicating the level of partial discharge.
Options:
\code{partial_discharge = c("Low", "Medium", "High",
 "Default")}. See page 144, table 183 in CNAIM (2017).}

\item{fault_hist}{Numeric. The calculated fault rate for the cable per annum
per kilometer. A setting of \code{"No historic faults recorded"}
indicates no fault. See page 144, table 184 in CNAIM (2017).}

\item{condition_armour}{String. Indicating the external condition of the
submarine cables armour. Options:
\code{condition_armour = c("Good","Poor","Critical","Default")}}

\item{age}{Numeric. The current age in years of the cable.}

\item{reliability_factor}{Numeric. \code{reliability_factor}
shall have a value between 0.6 and 1.5. A setting of \code{"Default"}
 sets the \code{reliability_factor} to 1.
See section 6.14 on page 69 in CNAIM (2017).}

\item{simulation_end_year}{Numeric. The last year of simulating probability
of failure. Default is 100.}
}
\value{
Numeric. Current probability of failure
per annum per kilometre.
}
\description{
This function calculates the Future
annual probability of failure per kilometer for submarine cables.
The function is a cubic curve that is based on
the first three terms of the Taylor series for an
exponential function. For more information about the
probability of failure function see section 6
on page 30 in CNAIM (2017).
}
\examples{
# Current annual probability of failure for 1 km EHV Sub Cable
pof_future_submarine_cables(
 sub_cable_type = "EHV Sub Cable",
 utilisation_pct = "Default",
 operating_voltage_pct = "Default",
 topography = "Default",
 sitution = "Default",
 wind_wave = "Default",
 intensity = "Default",
 landlocked = "no",
 sheath_test = "Default",
 partial_discharge = "Default",
 fault_hist = "Default",
 condition_armour = "Default",
 age = 10,
 reliability_factor = "Default",
 simulation_end_year = 100)
}
