% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bgnbd_pmf}
\alias{bgnbd_pmf}
\alias{bgnbd_nocov_PMF}
\alias{bgnbd_staticcov_PMF}
\title{BG/NBD: Probability Mass Function (PMF)}
\usage{
bgnbd_nocov_PMF(r, alpha, a, b, x, vT_i)

bgnbd_staticcov_PMF(r, x, vAlpha_i, vA_i, vB_i, vT_i)
}
\arguments{
\item{r}{shape parameter of the Gamma distribution of the purchase process}

\item{alpha}{scale parameter of the Gamma distribution of the purchase process}

\item{a}{shape parameter of the Beta distribution of the lifetime process}

\item{b}{shape parameter of the Beta distribution of the lifetime process}

\item{x}{The number of transactions to calculate the probability for (unsigned integer).}

\item{vT_i}{Number of periods since the customer came alive.}

\item{vAlpha_i}{Vector of individual parameters alpha}

\item{vA_i}{Vector of individual parameters a}

\item{vB_i}{Vector of individual parameters b}
}
\value{
Returns a vector of probabilities.
}
\description{
Calculate P(X(t)=x), the probability that a randomly selected customer
makes exactly x transactions in the interval (0, t].
}
\references{
Fader PS, Hardie BGS, Lee KL (2005). \dQuote{\dQuote{Counting Your Customers} the Easy Way:
An Alternative to the Pareto/NBD Model} Marketing Science, 24(2), 275-284.

Fader PS, Hardie BGS (2013). \dQuote{Overcoming the BG/NBD Model's #NUM! Error Problem}
URL \url{http://brucehardie.com/notes/027/bgnbd_num_error.pdf}.

Fader PS, Hardie BGS (2007). \dQuote{Incorporating time-invariant covariates into the
Pareto/NBD and BG/NBD models.}
URL \url{http://www.brucehardie.com/notes/019/time_invariant_covariates.pdf}.

Fader PS, Hardie BGS, Lee KL (2007). \dQuote{Creating a Fit Histogram for the BG/NBD Model}
URL \url{https://www.brucehardie.com/notes/014/bgnbd_fit_histogram.pdf}
}
