% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CITMIC.R
\name{CITMIC}
\alias{CITMIC}
\title{CITMIC}
\usage{
CITMIC(GEP,weighted = TRUE,base = 10,damping=0.90,cl.cores=1,cell.type=NULL)
}
\arguments{
\item{GEP}{An example gene expression profile.}

\item{weighted}{This parameter specifies whether to create a weighted graph for the cell crosstalk network. If null, an unweighted graph is created, and the elements of the adjacency matrix indicate the number of edges between vertices. If true, a weighted graph is created(default: TRUE).}

\item{base}{Standardized log base of data for improving data distribution(default: 10).}

\item{damping}{Restart the probability of the random-walk algorithm (default: 0.9).}

\item{cl.cores}{The number of CPU cores applied to this task(default:1).}

\item{cell.type}{Preset the relevant cell type (e.g. if the solid tumour tissue does not contain 'HSC', it is better to remove it when we preset it.)}
}
\value{
A data frame containing the cell infiltration score for each sample.
}
\description{
The function "CITMIC" is used to identify cell infiltration in tumor microenvironment by calculating intercellular crosstalk.
}
\examples{
# Obtain the example data
GEP<-GetData_CITMIC("GEP")
# Run the function
\donttest{lnScore<-CITMIC(GEP,weighted = TRUE,base = 10,damping=0.90,cl.cores=1,cell.type=NULL)}
}
