% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{wiener_index_centrality}
\alias{wiener_index_centrality}
\title{Wiener Index Centrality}
\usage{
wiener_index_centrality(
  x,
  vids = V(x),
  mode = c("all", "out", "in"),
  weights = NULL
)
}
\arguments{
\item{x}{An igraph or a network object}

\item{vids}{Nodes to be considered in the calculation}

\item{mode}{A Character value, indicating whether the shortest paths "in" or "out" of the nodes in the directed graphs should be considered. For undirected graphs we use "all".}

\item{weights}{Numeric vector indicating weights of the edges}
}
\value{
a vector including centrality values for each node
}
\description{
This function computes Wiener Index Centrality.
The Wiener index computes the sum of the all shortest paths
between a node v and all other related nodes in the graph.
Fundementally, it's like to the closeness but here since the reciprocal is not computed, the value has the opposite meaning.
}
\examples{

data(zachary)

wiener_index_centrality(zachary)

}
\references{
Scardoni, G. and Carlo Laudanna, C.B.M.C., 2011. Network centralities for Cytoscape. University of Verona.
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
