% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{visualize.dendogram}
\alias{visualize.dendogram}
\title{Dendrogram visualization based on a specific centrality measure}
\usage{
visualize.dendogram(x, centrality.type = "Degree Centrality",
  computed.centrality.value = NULL, k = 4)
}
\arguments{
\item{x}{an igraph object}

\item{centrality.type}{The type of centrality which should be considered.(default="Degree Centrality")}

\item{computed.centrality.value}{A vector containing the values of calculated centrality measure for each node.(default=NULL)}

\item{k}{number of clusters(default=4)}
}
\description{
This function demonstrates the vertice dendrogram of a graph based
on a centrality type.
}
\details{
This function represents node dendrogram of a graph based on a centrality measure.
If the favor centrality is not computed yet, by specifying the name of that it will compute it and show the result.
}
\references{
Galili, T. (2015). dendextend: an R package for visualizing, adjusting and comparing trees of hierarchical clustering. Bioinformatics, 31(22), 3718–3720.

Gu, Z., Gu, L., Eils, R., Schlesner, M., & Brors, B. (2014). circlize implements and enhances circular visualization in R. Bioinformatics, 30(19), 2811–2812.
}
\seealso{
\code{\link[stats]{dendrogram}}
}
\author{
Minoo Ashtiani, Mohieddin Jafari
}
