% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_p2.R
\name{data_gen_p2}
\alias{data_gen_p2}
\title{Data generation function for scenario 2
This function generates data to test different causal inference methods for scenario 2.  Please use our main function data_gen.R}
\usage{
data_gen_p2(n = 11600, p = 10, overlap = "weak",
  all_confounder = TRUE)
}
\arguments{
\item{n}{total number of units for simulation}

\item{p}{number of predictors}

\item{overlap}{levels of covariate overlap: Please select: weak, strong, moderate}

\item{all_confounder}{TRUE or FALSE. overlap is lacking for a variable that is not predictive of the outcome (all_confounder equals to TRUE) or situations when it is lacking for a true confounder (all_confounder equals to FALSE)}
}
\value{
list with the 5 elements. Nested within each list, it contains
\item{n:}{Number of units for simulation}
\item{trt_ind:}{A data frame with number of rows equals to n and 11 columns}
\item{Y:}{Observed binary outcome for 3 treatments}
\item{Yobs:}{Observed binary outcome}
\item{Est:}{True ATE/ATT for RD/RR/OR}
}
\description{
Data generation function for scenario 2
This function generates data to test different causal inference methods for scenario 2.  Please use our main function data_gen.R
}
\examples{
library(CIMTx)
set.seed(3242019)
data_gen_p2(n = 116, p =10, overlap = "weak", all_confounder = TRUE)
}
