% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sr_to_nifti.R
\name{Sr_to_nifti}
\alias{Sr_to_nifti}
\title{Convert Cluster specific independent components to NIFTI format}
\usage{
Sr_to_nifti(x, write = FALSE, ...)
}
\arguments{
\item{x}{an object of \code{class} CICA}

\item{write}{if TRUE, NIfTI files are written to current working directory}

\item{...}{other arguments passed to RNifti::writeNifti}
}
\value{
a list with niftiImage files
}
\description{
Convert Cluster specific independent components to NIFTI format
}
\examples{
\dontrun{
nifs <- loadNIfTIs('<FolderPath>', toMatrix = T)
outnif <- CICA(DataList = nifs, RanStarts = 2, nComp = 10, nClus = 2)
test <- Sr_to_nifti(outnif,write = T, datatype = 'int16', version = 2)
}

}
