\encoding{UTF-8}
\name{eqdata}
\alias{eqdata}
\title{Read data from an EQ6 output file}
\description{
Extract computational results for aqueous species, solid phases, mineral saturation states, or speciation summaries at each step of reaction progress in an EQ6 output file.
The results are written to a comma-separated value file that can be read by other programs.
The function has been tested with output files generated by EQ3/6 version 7.1 running on a Unix platform.
Currently there is only partial support for version 8.0a (reading data from aqueous species blocks).
}

\usage{
  eqdata(file, species, property = "log act", outfile = TRUE)
}

\arguments{
  \item{file}{character, path to EQ6 output file}
  \item{species}{character, name(s) of species or minerals}
  \item{property}{character, property to get}
  \item{outfile}{logical or character, file for saving results}
}

\details{

  The first argument, \code{file}, is the name of the EQ6 (Wolery, 1992; Wolery and Daveler, 1992) output file. \code{species} indicates the aqueous species, solid phases, minerals, or basis species for which you want values; multiple names can be provided except for basis species, which can be a single value. \code{property} indicates the property to retrieve. Specifying a value other than one listed below will cause an error.

  \itemize{
    \item Aqueous species: \samp{conc}, \samp{log conc}, \samp{log g}, or \samp{log act}
    \item Solid phases: \samp{log moles}, \samp{moles}, \samp{grams}, or \samp{volume, cc}
    \item Minerals (saturation states): \samp{affinity, kcal}
    \item Basis species (speciation): \samp{molal conc} or \samp{per cent}
  }


  The result of the function is a data frame (returned invisibly), with columns \code{zi} (reaction progress), \code{T} (temperature in \degC, \code{aH2O} (activity of water) and one column for each of the requested \code{species} or, for speciation of basis species, one column for each unique species found in all of the speciation summary blocks for that basis species. Values are listed as NA (not available) for species or phases that are not present in the EQ6 output at any of the increments of reaction progress. 

  If \code{outfile} is TRUE, the result is saved in a file named like \samp{file}.\samp{property}.\code{csv}, in the same directory as \code{file}. The name of the \code{outfile} can be provided to override this naming scheme, or this argument can be set to FALSE or NULL, to turn off writing the result to a file.

  Thanks to Peter Canovas and Everett Shock for helping to test the code and offering ideas for improvements.
}

\references{
  Wolery, T. J. (1992) EQ3/6, A Software Package for Geochemical Modeling of Aqueous Systems: Package Overview and Installation Guide (Version 7.0). Lawrence Livermore National Laboratory, UCRL-MA-110662 PT I. \url{https://www.wipp.energy.gov/library/cra/2009_cra/references/Others/Wolery_1992_EQ36_A_Software_Package_for_Geochemical_Modeling_of_Aqueous_Systems_ERMS241375.pdf}

  Wolery, T. J. and Daveler, S. A. (1992) EQ6, A Computer Program for Reaction Path Modeling of Aqueous Geochemical Systems: Theoretical Manual, User's Guide, and Related Documentation (Version 7.0). Lawrence Livermore National Laboratory, UCRL-MA-110662 PT IV. \url{https://www.wipp.energy.gov/library/cra/2009_cra/references/Others/Wolery_Daveler_1992_EQ36_A_Computer_Program_for_Reaction_Path_Modeling_of_Aqueous_Geochemical_Systems_ERMS241379.pdf}

}

\examples{
\dontrun{
# if an EQ6 output file named "rainbow2.6o" is in the current 
# working directory, the following command will output values 
# of log act (logarithm of activity) for the selected aqueous 
# species to a file named rainbow2.6o.log act.csv
eqdata("rainbow2.6o",c("h+","sio2,aq","h2,aq"),"log act") }
}

\concept{Other tools}
