% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OurConfidence.R
\name{OurConf}
\alias{OurConf}
\title{Plotting random samples of confidence intervals around the mean}
\usage{
OurConf(samples = 100, n = 30, mu = 0, sigma = 1,
  conf.level = 0.95)
}
\arguments{
\item{samples}{The number of times to draw random samples}

\item{n}{The sample size we draw each time}

\item{mu}{The population mean mu}

\item{sigma}{The population standard deviation}

\item{conf.level}{What confidence level to compute 1 - alpha (significance level)}
}
\value{
A ggplot2 object
}
\description{
This function takes some parameters and simulates random samples and
their confidence intervals
}
\examples{
OurConf(samples = 100, n = 30, mu = 0, sigma = 1, conf.level = 0.95)
OurConf(samples = 2, n =5)
OurConf(samples = 25, n = 25, mu = 100, sigma = 20, conf.level = 0.99)

}
\seealso{
\code{\link[stats]{qnorm}}, \code{\link[stats]{rnorm}}, \code{\link[BSDA]{CIsim}}
}
\author{
Chuck Powell
}
