% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyCGNM_related.R
\name{make_ShinyCGNM_observationData}
\alias{make_ShinyCGNM_observationData}
\title{make_ShinyCGNM_observationData}
\usage{
make_ShinyCGNM_observationData(
  ID,
  time,
  Observation_expression,
  Observed_value,
  ResidualError_model,
  Memo = NA,
  fileName = NA
)
}
\arguments{
\item{ID}{(required input) \emph{string or vector}}

\item{time}{(required input) \emph{number or numeric vector}}

\item{Observation_expression}{(required input) \emph{string or string vector}}

\item{Observed_value}{(required input) \emph{number or numeric vector}}

\item{ResidualError_model}{(required input) \emph{0 or 1} 0: additive residual model, 1: relative residual model}

\item{Memo}{(default: NA)  \emph{NA, string, or string vector} If TRUE plot absolute values of the residual.}

\item{fileName}{(default: NA) \emph{NA or string}}
}
\value{
\emph{data.frame} if fileName is NA \emph{Null} if fileName is not NA but instead write out the csv file
}
\description{
A helper function to write out the csv file that can be read in as the observation file in shinyCGNM
}
\examples{

make_ShinyCGNM_observationData(
ID=1,
time=c(1,2,3,6,12,24),
Observation_expression="C_central",
Observed_value=c(0.1, 0.3, 0.6, 0.1, 0.05, 0.01),
ResidualError_model=1
)

}
