% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_create_fs.R
\name{CGGPcreate}
\alias{CGGPcreate}
\title{Create sparse grid GP}
\usage{
CGGPcreate(
  d,
  batchsize,
  corr = "PowerExponential",
  grid_sizes = c(1, 2, 4, 4, 8, 12, 20, 28, 32),
  Xs = NULL,
  Ys = NULL,
  HandlingSuppData = "Correct",
  supp_args = list()
)
}
\arguments{
\item{d}{Input dimension}

\item{batchsize}{Number added to design each batch
for now only on predictions}

\item{corr}{Name of correlation function to use. Must be one of "CauchySQT",
"CauchySQ", "Cauchy", "Gaussian", "PowerExp", "Matern32", "Matern52".}

\item{grid_sizes}{Size of grid refinements.}

\item{Xs}{Supplemental X data}

\item{Ys}{Supplemental Y data}

\item{HandlingSuppData}{How should supplementary data be handled?
* Correct: full likelihood with grid and supplemental data
* Only: only use supplemental data
* Ignore: ignore supplemental data}

\item{supp_args}{Arguments used to fit if Xs and Ys are given}
}
\value{
CGGP
}
\description{
Create sparse grid GP
}
\examples{
CGGPcreate(d=8,200)
}
\seealso{
Other CGGP core functions: 
\code{\link{CGGPappend}()},
\code{\link{CGGPfit}()},
\code{\link{predict.CGGP}()}
}
\concept{CGGP core functions}
