% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{save_query}
\alias{save_query}
\title{Save Search Query}
\usage{
save_query(
  uri_fun,
  user,
  password,
  host,
  port,
  database,
  search_query,
  use_negation,
  hide_duplicates,
  skip_after_event
)
}
\arguments{
\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}

\item{search_query}{Medical corpus query containg keywords/CUI's, boolean elements and other operators ('AND', 'OR', '!', '(', or ')').}

\item{use_negation}{Should negated items be ignored in the keyword/concept search?}

\item{hide_duplicates}{Should duplicated sentences be removed for search results?}

\item{skip_after_event}{Should sentences occurring after recorded clinical event be skipped?}
}
\value{
{
Confirmation that requested operation was completed, or error message if attempt failed.
}
}
\description{
Saves the search query. The query consists of keywords/UMLS concept unique identifiers (CUI's), boolean elements and other operators ('AND', 'OR', '!', '(', or ')').
}
\examples{
\dontrun{
save_query(uri_fun = mongo_uri_standard, user = 'John', password = 'db_password_1234',
host = 'server1234', port = NA, database = 'TEST_PROJECT', search_query = 'thrombosis AND venous',
use_negation = TRUE, hide_duplicates = TRUE, skip_after_event = TRUE)
}
}
