% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEDA.R
\name{preparePlotData}
\alias{preparePlotData}
\title{Prepare data for density plot and ridge plot}
\usage{
preparePlotData(data, gene.fdr)
}
\arguments{
\item{data}{A data frame containing each gene in one row, and at least three columns with geneID, geneLFC, and geneFDR.}

\item{gene.fdr}{A numeric variable (column) in the data frame, corresponding to the gene level FDR}
}
\value{
A data frame based on the original data frame, with an additional column "group" indicating which FDR group this gene belongs to.
}
\description{
Input a data frame with each gene one row, and geneID, geneLFC, geneFDR as columns. 
This function will stratify genes into five groups based on their FDR levels: <=0.001, (0.001,0.01], 
(0.01,0.05], (0.05,0.5], (0.5,1]
}
