% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdnet.R
\name{summary.cdnet}
\alias{summary.cdnet}
\alias{print.summary.cdnet}
\alias{print.cdnet}
\alias{summary.cdnets}
\alias{print.summary.cdnets}
\alias{print.cdnets}
\title{Summarize Count Data Model with Social Interactions}
\usage{
\method{summary}{cdnet}(object, Glist, data, S = 1000L, ...)

\method{print}{summary.cdnet}(x, ...)

\method{print}{cdnet}(x, ...)

\method{summary}{cdnets}(object, ...)

\method{print}{summary.cdnets}(x, ...)

\method{print}{cdnets}(x, ...)
}
\arguments{
\item{object}{an object of class \code{cdnet}, output of the function \code{\link{cdnet}}.}

\item{Glist}{adjacency matrix or list sub-adjacency matrix. This is not necessary if the covariance method was computed in \link{cdnet}.}

\item{data}{a \code{dataframe} containing the explanatory variables. This is not necessary if the covariance method was computed in \link{cdnet}.}

\item{S}{number of simulation to be used to compute integral in the covariance by important sampling.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class \code{summary.cdnet}, output of the function \code{\link{summary.cdnet}},
class \code{summary.cdnets}, list of outputs of the function \code{\link{summary.cdnet}}
(when the model is estimated many times to control for the endogeneity)
or class \code{cdnet} of the function \code{\link{cdnet}}.}
}
\value{
A list of the same objects in \code{object}.
}
\description{
Summary and print methods for the class \code{cdnet} as returned by the function \link{cdnet}.
}
