% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCI.direction.R
\name{CCI.direction}
\alias{CCI.direction}
\title{Choose Direction for testing for the CCI test}
\usage{
CCI.direction(
  formula,
  data,
  method = "rf",
  folds = 4,
  nrounds = 600,
  max_depth = 6,
  eta = 0.3,
  gamma = 0,
  colsample_bytree = 1,
  min_child_weight = 1,
  subsample = 1,
  poly = TRUE,
  degree = 3,
  interaction = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{formula}{A formula object specifying the model to be fitted.}

\item{data}{A data frame containing the variables specified in the formula.}

\item{method}{A character string specifying the method to be used for model fitting. Options include "rf" (random forest), "xgboost" (XGBoost), "nnet" (neural network), "gpr" (Gaussian process regression), and "svm" (support vector machine).}

\item{folds}{An integer specifying the number of folds for cross-validation. Default is 4.}

\item{nrounds}{Integer. The number of rounds (trees) for methods like xgboost, ranger, and lightgbm. Default is 600.}

\item{max_depth}{Integer. The maximum depth of the trees for methods like xgboost. Default is 6.}

\item{eta}{Numeric. The learning rate for methods like xgboost. Default is 0.3.}

\item{gamma}{Numeric. The minimum loss reduction required to make a further partition on a leaf node of the tree for methods like xgboost. Default is 0.}

\item{colsample_bytree}{Numeric. The subsample ratio of columns when constructing each tree for methods like xgboost. Default is 1.}

\item{min_child_weight}{Numeric. The minimum sum of instance weight (hessian) needed in a child for methods like xgboost. Default is 1.}

\item{subsample}{Numeric. The proportion of the data to be used for subsampling. Default is 1 (no subsampling).}

\item{poly}{Logical. If TRUE, polynomial terms of the conditioning variables are included in the model. Default is TRUE.}

\item{degree}{Integer. The degree of polynomial terms to include if \code{poly} is TRUE. Default is 3.}

\item{interaction}{Logical. If TRUE, interaction terms of the conditioning variables are included in the model. Default is TRUE.}

\item{verbose}{Logical. If TRUE, prints additional information during the execution. Default is FALSE.}

\item{...}{Additional arguments to be passed to the model fitting function.}
}
\value{
A formula object specifying the selected model direction.
}
\description{
This function selects the best direction for the CCI test based on cross validation. For the condition Y \emph{||} X | Z, the function return the recommended
formula either Y ~ X | Z or X ~ Y | Z .
}
