% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzz.R
\name{fuzz}
\alias{fuzz}
\title{Fuzz-test the specified functions}
\usage{
fuzz(
  funs,
  what = test_inputs(),
  package = NULL,
  listify_what = FALSE,
  ignore_patterns = "",
  ignore_warnings = FALSE
)
}
\arguments{
\item{funs}{A character vector of function names to test. If a \code{"package"}
attribute is set and is no \code{package} argument is provided, functions
are loaded from the namespace specified in the attribute.}

\item{what}{A list of objects to be passed, one at a time, as the first
argument to each function in \code{funs}. Ideally, the list should be
named, so that each input tested can be pretty-printed with the
corresponding name. For unnamed lists, a deparsed representation of
the inputs will be used, which may appear unwieldy in some cases.
If nothing is provided, a default set of inputs generated by
\link{test_inputs} will be used.}

\item{package}{A character string specifying the name of the package to
search for functions. If \code{NULL} (default), the function will first
check the \code{"package"} attribute of \code{funs}, and if that is not set,
names will be searched in the global namespace.}

\item{listify_what}{Whether each input in \code{what} should also be tested
in its listified version (\code{FALSE} by default). When set to \code{TRUE},
if \code{what} is \code{list(x = x)}, the function will operate as if \code{what}
were \code{list(x = x, "list(x)" = list(x))}, for any input object \code{x}.}

\item{ignore_patterns}{One or more strings containing regular expressions
to match the errors to ignore. The string "is missing, with no
default" is always ignored.}

\item{ignore_warnings}{Whether warnings should be ignored (\code{FALSE} by
default).}
}
\value{
An object of class \code{cbtf} that stores the results obtained for each of the
functions tested. This contains the following fields:
\item{$runs}{a list of data frames, each containing the results of fuzzing
all the functions in \code{funs} with one of the inputs in \code{what}, with
attribute "what" containing . The data frame contains the following
columns and attributes:\cr
- \code{fun}: The name of the function tested.\cr
- \code{res}: The result of the fuzz test, see below for the possible
values.\cr
- \code{msg}: The error or warning message returned by the function, if
any.\cr
- \verb{attr(*, "what")}: The character representation of the input
tested.
}
\item{$package}{a character string specifying the package name where
function names were searched, or \code{NA} if none was provided.}

The \code{res} column in each of the data frames in the \verb{$runs} field can
contain the following values:
\itemize{
\item OK: either no error or warning was produced (in which case, the \code{msg}
entry is left blank), or it was whitelisted (in which case, the message
received is stored in \code{msg}).
\item SKIP: no test was run, either because the given name cannot be found, or
it doesn't correspond to a function, or the function accepts no arguments,
or the function contains a call to \link{readline}; the exact reason is given
in \code{msg}.
\item WARN: a warning was thrown for which no whitelisting occurred and
\code{ignore_warnings = FALSE}; its message is stored in \code{msg}.
\item FAIL: an error was thrown for which no whitelisting occurred; its message
is stored in \code{msg}.
}
}
\description{
This function calls each of the functions in \code{funs} with each of the
objects specified in \code{what}, recording if any errors or warnings are
thrown in the process.
}
\details{
In order to reduce the number of false positive results produced, this
function applies the following set rules, to establish if an error or
warning condition should ignored (whitelisting):
\itemize{
\item If the name of the function appears in the error or warning message, as
it is considered that the condition has been handled by the developer.
\item If the error or warning message contains the text "is missing, with no
default", which is produced when a missing argument is used without a
value being assigned to it.
\item If the error or warning message contains any of the patterns specified
in \code{ignore_patterns}.
\item If a warning is thrown but \code{ignore_warnings = TRUE} is set.
}

In all whitelisted cases, the result is "OK", and the message that
was received is stored in the \verb{$msg} field (see the \emph{Value} section).
}
\examples{
## this should produce no errors
res <- fuzz(funs = c("list", "matrix", "mean"),
            what = test_inputs(c("numeric", "raw")))
summary(res)

## display all results even for successful tests
print(res, show_all = TRUE)

## this will catch an error (false positive)
fuzz(funs = "matrix",  what = test_inputs("scalar"))

}
\seealso{
\link{get_exported_functions}, \link{test_inputs}, \link{summary.cbtf},
\link{print.cbtf}
}
