% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{run_sgrna_quant}
\alias{run_sgrna_quant}
\title{A function to run a sgRA qunatification algorithm from NGS samples}
\usage{
run_sgrna_quant(lib_path, design)
}
\arguments{
\item{lib_path}{The path of annotation file.}

\item{design}{A table contains study design. It has to contain `fastq_path` and `sample_name`.}
}
\value{
It will return a list, and the list contains two elements. 
  The first elements (`count`) is a table contains the result of the quantification for each sample. 
  The second elements (`total`) is a vector contains the total number of reads of each sample.
}
\description{
A function to run a sgRA qunatification algorithm from NGS samples
}
\examples{
library(CB2)
library(magrittr)
library(tibble)
library(dplyr)
library(glue)
FASTA <- system.file("extdata", "toydata", "small_sample.fasta", package = "CB2")
ex_path <- system.file("extdata", "toydata", package = "CB2")

df_design <- tribble(
  ~group, ~sample_name,
  "Base", "Base1",  
  "Base", "Base2", 
  "High", "High1",
  "High", "High2") \%>\% 
    mutate(fastq_path = glue("{ex_path}/{sample_name}.fastq"))

cb2_count <- run_sgrna_quant(FASTA, df_design)

}
