#ifndef CAR_LASSO_HELPER_H
#define CAR_LASSO_HELPER_H

arma::mat update_car_beta_helper(const arma::mat & data,
                                 const arma::mat & design,
                                 const arma::vec & mu,
                                 const arma::vec & tau2,
                                 const arma::mat & Omega,
                                 int k, int p, int n);
                             
arma::vec update_car_mu_helper(const arma::mat & data,
                               const arma::mat & design,
                               const arma::mat & beta,
                               const arma::mat & Omega, 
                               int k,int p,int n);

void update_car_Omega_helper(arma::mat & Omega,
                             const arma::mat & data,
                             const arma::mat & design,
                             const arma::vec & mu,
                             const arma::mat & beta,
                             const double & lambda_curr,
                             int k, int p,int n);

arma::vec update_car_tau2_helper(const arma::mat & beta,
                             const double & lambda2,
                             const arma::mat & Omega,
                             int k, int p, int n);

arma::mat getDesign_i_helper_dense(const arma::rowvec & X_i,//row vector of that sample
                                   int k);

#endif
