% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_boot.R
\name{se_boot}
\alias{se_boot}
\title{Bootstrap standard errors}
\usage{
se_boot(x1, x2, dif, boot.R = 999)
}
\arguments{
\item{x1}{vector of observations}

\item{x2}{vector of observations}

\item{dif}{name of the difference for which the SE is desired. Accepts
"simple" (simple differences) or "perc" (percent differences).}

\item{boot.R}{(optional) number of bootstrap resamples}
}
\value{
estimated standard error
}
\description{
Calculates the standard error of a given statistic using bootstrap
}
\section{References}{

\itemize{
\item A.C. Davison, D.V. Hinkley:
Bootstrap methods and their application. Cambridge University Press (1997)
\item F. Campelo, F. Takahashi:
Sample size estimation for power and accuracy in the experimental
comparison of algorithms (submitted, 2017).
}
}

\examples{
# two vectors of normally distributed observations
set.seed(1234)
x1 <- rnorm(100, 5, 1)  # mean = 5, sd = 1
x2 <- rnorm(200, 10, 2) # mean = 10, sd = 2

# Theoretical SE for simple difference: 0.1732051
se_boot(x1, x2, dif = "simple")

# Theoretical (Fieller, no covariance) SE for percent differences: 0.04
se_boot(x1, x2, dif = "perc")
}
\author{
Felipe Campelo (\email{fcampelo@ufmg.br})
}
