/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.DataLoader;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class TraitMetricCalculator
extends DataPlotDialog {
    private JPanel analysisOptsPane;
    private JButton coeffBrowseButton;
    private JComboBox coeffComboBox;
    private JLabel coeffLabel;
    private JPanel mainPane;
    private JPanel plotPane;
    private JLabel resultLabel;
    private JTextField resultName;
    private JPanel savePanel;
    private JCheckBox saveResults;
    private JComboBox siteComboBox;
    private JLabel siteLabel;
    private JComboBox taxonCountComboBox;
    private JLabel taxonCountLabel;
    private JComboBox taxonNameComboBox;
    private JLabel taxonNameLabel;
    private JPanel varPane;

    @Override
    protected void initCustom() {
        this.initComponents();
        this.getPlotPane().add((Component)this.plotPane, "Center");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TraitMetricCalculator.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.refreshVariableList();
        this.refreshValidity();
    }

    private void datasetComboBoxActionPerformed(ActionEvent e) {
        this.refreshVariableList();
        this.refreshValidity();
    }

    public void refreshVariableListValidity() {
        boolean datasetValid = this.getDatasetPane().getDatasetComboBox().getItemCount() > 0;
        this.siteLabel.setEnabled(datasetValid && this.siteComboBox.getItemCount() > 0);
        this.siteComboBox.setEnabled(datasetValid && this.siteComboBox.getItemCount() > 0);
        this.taxonNameLabel.setEnabled(datasetValid && this.taxonNameComboBox.getItemCount() > 0);
        this.taxonNameComboBox.setEnabled(datasetValid && this.taxonNameComboBox.getItemCount() > 0);
        this.taxonCountLabel.setEnabled(datasetValid && this.taxonCountComboBox.getItemCount() > 0);
        this.taxonCountComboBox.setEnabled(datasetValid && this.taxonCountComboBox.getItemCount() > 0);
    }

    public void refreshVariableList() {
        boolean datasetValid;
        boolean bl = datasetValid = this.getDatasetPane().getDatasetComboBox().getItemCount() > 0;
        if (datasetValid) {
            Vector colNames = null;
            try {
                colNames = RUtils.colnamesVector(this.getDatasetPane().getSelectedDataset());
                this.siteComboBox.setModel(new DefaultComboBoxModel(colNames));
                this.taxonNameComboBox.setModel(new DefaultComboBoxModel(colNames));
                this.taxonCountComboBox.setModel(new DefaultComboBoxModel(colNames));
                if (this.siteComboBox.getItemCount() > 0) {
                    this.siteComboBox.setSelectedIndex(0);
                }
                if (this.taxonNameComboBox.getItemCount() > 0) {
                    this.taxonNameComboBox.setSelectedIndex(0);
                }
                if (this.taxonCountComboBox.getItemCount() > 0) {
                    this.taxonCountComboBox.setSelectedIndex(0);
                }
            }
            catch (REngineException ex) {
                Logger.getLogger(TraitMetricCalculator.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(TraitMetricCalculator.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.siteComboBox.removeAllItems();
            this.taxonNameComboBox.removeAllItems();
            this.taxonCountComboBox.removeAllItems();
        }
        this.refreshValidity();
    }

    public void refreshSubmitButtonValidity() {
        this.getSubmitButton().setEnabled(this.getDatasetPane().getDatasetComboBox().getSelectedIndex() != -1 && this.siteComboBox.getSelectedIndex() != -1 && this.taxonNameComboBox.getSelectedIndex() != -1 && this.taxonCountComboBox.getSelectedIndex() != -1 && this.coeffComboBox.getSelectedIndex() != -1);
    }

    public void refreshValidity() {
        this.refreshVariableListValidity();
        this.refreshSubmitButtonValidity();
    }

    private void initComponents() {
        this.plotPane = new JPanel();
        this.mainPane = new JPanel();
        this.varPane = new JPanel();
        this.siteLabel = new JLabel();
        this.siteComboBox = new JComboBox();
        this.taxonNameLabel = new JLabel();
        this.taxonNameComboBox = new JComboBox();
        this.taxonCountLabel = new JLabel();
        this.taxonCountComboBox = new JComboBox();
        this.analysisOptsPane = new JPanel();
        this.coeffLabel = new JLabel();
        this.coeffComboBox = new JComboBox();
        this.coeffBrowseButton = new JButton();
        this.savePanel = new JPanel();
        this.saveResults = new JCheckBox();
        this.resultLabel = new JLabel();
        this.resultName = new JTextField();
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.siteLabel.setText("Site ID:");
        this.siteComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TraitMetricCalculator.this.siteComboBoxActionPerformed(evt);
            }
        });
        this.taxonNameLabel.setText("Taxon Name:");
        this.taxonNameComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TraitMetricCalculator.this.taxonNameComboBoxActionPerformed(evt);
            }
        });
        this.taxonCountLabel.setText("Taxon Count:");
        this.taxonCountComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TraitMetricCalculator.this.taxonCountComboBoxActionPerformed(evt);
            }
        });
        GroupLayout varPaneLayout = new GroupLayout(this.varPane);
        this.varPane.setLayout(varPaneLayout);
        varPaneLayout.setHorizontalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.taxonCountLabel).addComponent(this.taxonNameLabel).addComponent(this.siteLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.taxonCountComboBox, GroupLayout.Alignment.TRAILING, 0, 369, Short.MAX_VALUE).addComponent(this.siteComboBox, GroupLayout.Alignment.TRAILING, 0, 369, Short.MAX_VALUE).addComponent(this.taxonNameComboBox, 0, 369, Short.MAX_VALUE)).addContainerGap()));
        varPaneLayout.setVerticalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.siteComboBox, -2, -1, -2).addComponent(this.siteLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.taxonNameLabel).addComponent(this.taxonNameComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.taxonCountComboBox, -2, -1, -2).addComponent(this.taxonCountLabel)).addContainerGap()));
        this.analysisOptsPane.setBorder(BorderFactory.createTitledBorder("Analysis Options"));
        this.coeffLabel.setText("Coefficient Data:");
        this.coeffBrowseButton.setText("Browse...");
        this.coeffBrowseButton.setMargin(new Insets(0, 10, 0, 10));
        this.coeffBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TraitMetricCalculator.this.coeffBrowseButtonActionPerformed(evt);
            }
        });
        GroupLayout analysisOptsPaneLayout = new GroupLayout(this.analysisOptsPane);
        this.analysisOptsPane.setLayout(analysisOptsPaneLayout);
        analysisOptsPaneLayout.setHorizontalGroup(analysisOptsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptsPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.coeffLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.coeffComboBox, -2, 219, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.coeffBrowseButton).addContainerGap(-1, Short.MAX_VALUE)));
        analysisOptsPaneLayout.setVerticalGroup(analysisOptsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptsPaneLayout.createSequentialGroup().addContainerGap().addGroup(analysisOptsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.coeffLabel).addComponent(this.coeffComboBox, -2, -1, -2).addComponent(this.coeffBrowseButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.savePanel.setBorder(BorderFactory.createTitledBorder("Results"));
        this.saveResults.setText("Save R Results?");
        this.saveResults.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.saveResults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TraitMetricCalculator.this.saveResultsActionPerformed(evt);
            }
        });
        this.resultLabel.setText("Result Name:");
        this.resultLabel.setEnabled(false);
        this.resultName.setColumns(12);
        this.resultName.setText("pecboResult");
        this.resultName.setEnabled(false);
        GroupLayout savePanelLayout = new GroupLayout(this.savePanel);
        this.savePanel.setLayout(savePanelLayout);
        savePanelLayout.setHorizontalGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(savePanelLayout.createSequentialGroup().addGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(savePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.saveResults)).addGroup(savePanelLayout.createSequentialGroup().addGap(56, 56, 56).addComponent(this.resultLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultName, -1, 326, Short.MAX_VALUE))).addContainerGap()));
        savePanelLayout.setVerticalGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(savePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.saveResults).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resultLabel).addComponent(this.resultName, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout mainPaneLayout = new GroupLayout(this.mainPane);
        this.mainPane.setLayout(mainPaneLayout);
        mainPaneLayout.setHorizontalGroup(mainPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.analysisOptsPane, -1, -1, Short.MAX_VALUE).addComponent(this.varPane, -1, -1, Short.MAX_VALUE).addComponent(this.savePanel, -1, -1, Short.MAX_VALUE));
        mainPaneLayout.setVerticalGroup(mainPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPaneLayout.createSequentialGroup().addComponent(this.varPane, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.analysisOptsPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.savePanel, -2, -1, -2)));
        this.plotPane.add(this.mainPane);
        this.setTitle("Predicting Env. Conditions from Bio. Observations (PECBO)");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 690) / 2, (screenSize.height - 603) / 2, 690, 603);
    }

    private void saveResultsActionPerformed(ActionEvent evt) {
        this.resultLabel.setEnabled(this.saveResults.isSelected());
        this.resultName.setEnabled(this.saveResults.isSelected());
    }

    private void coeffBrowseButtonActionPerformed(ActionEvent evt) {
        DataLoader loader = new DataLoader();
        String dataName = loader.getDataName();
        JGR.MAINRCONSOLE.toBack();
        if (dataName == null || dataName.length() > 0) {
            // empty if block
        }
    }

    private void siteComboBoxActionPerformed(ActionEvent evt) {
        this.refreshSubmitButtonValidity();
    }

    private void taxonNameComboBoxActionPerformed(ActionEvent evt) {
        this.refreshSubmitButtonValidity();
    }

    private void taxonCountComboBoxActionPerformed(ActionEvent evt) {
        this.refreshSubmitButtonValidity();
    }

    @Override
    protected void submitButtonAction() {
        String cmd = "bioinfer.new.JGR(my.data=" + this.getDatasetPane().getSelectedDataset() + ", subset1.name=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'") + ", subset1.val=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")") + ", subset2.name=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'") + ", subset2.val=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")") + ", saveName=" + "'" + this.resultName.getText() + "'" + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    @Override
    protected void helpButtonAction() {
        String cmd = "CADStat.help('bioinfer.new.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        Object site = this.siteComboBox.getSelectedItem();
        Object tName = this.taxonNameComboBox.getSelectedItem();
        Object tCount = this.taxonCountComboBox.getSelectedItem();
        this.getDatasetPane().refreshDatasetComboBox();
        GUIUtils.refreshDataset(this.coeffComboBox);
        this.siteComboBox.setSelectedItem(site);
        this.taxonNameComboBox.setSelectedItem(tName);
        this.taxonCountComboBox.setSelectedItem(tCount);
        this.refreshFactorSelectionPanes();
        this.refreshValidity();
    }
}

