% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-setGeneric.R, R/S4-BuyseTest-get.R
\name{getIid}
\alias{getIid}
\alias{S4BuyseTest-getIid}
\alias{getIid,S4BuyseTest-method}
\title{Extract the H-decomposition of the Estimator}
\usage{
getIid(
  object,
  endpoint = NULL,
  statistic = NULL,
  stratified = FALSE,
  cumulative = TRUE,
  center = TRUE,
  scale = TRUE,
  type = "all",
  cluster = NULL
)

\S4method{getIid}{S4BuyseTest}(
  object,
  endpoint = NULL,
  statistic = NULL,
  stratified = FALSE,
  cumulative = TRUE,
  center = TRUE,
  scale = TRUE,
  type = "all",
  cluster = NULL
)
}
\arguments{
\item{object}{an \R object of class \code{\linkS4class{S4BuyseTest}}, i.e., output of \code{\link{BuyseTest}}}

\item{endpoint}{[character] for which endpoint(s) the H-decomposition should be output?
If \code{NULL} returns the sum of the H-decomposition over all endpoints.}

\item{statistic}{[character] statistic relative to which the H-decomposition should be output.}

\item{stratified}{[logical] should the H-decomposition relative to the strata-specific statistics be output?
Otherwise display the influence function of the global statistic (i.e. over all strata).}

\item{cumulative}{[logical] should the H-decomposition be cumulated over endpoints?
Otherwise display the contribution of each endpoint.}

\item{center}{[logical] if \code{TRUE} the H-decomposition is centered around 0 (estimated statistic is substracted).}

\item{scale}{[logical] if \code{TRUE} the H-decomposition is rescaled (by the sample size in the corresponding arm) such that its sums of squares approximate the variance of the estimator.}

\item{type}{[character] type of H-decomposition to be output.
Can be only for the nuisance parameters (\code{"nuisance"}),
or for the u-statistic given the nuisance parameters (\code{"u-statistic"}),
or both.}

\item{cluster}{[numeric vector] return the H-decomposition aggregated by cluster.}
}
\description{
Extract the H-decomposition of the GPC estimator.
}
\details{
WARNING: argument \code{scale} and \code{center} should be used with care as when set to \code{FALSE} they may not lead to a meaningful decomposition.
}
\seealso{
\code{\link{BuyseTest}} for performing a generalized pairwise comparison. \cr
\code{\link{S4BuyseTest-summary}} for a more detailed presentation of the \code{S4BuyseTest} object.
}
\author{
Brice Ozenne
}
\keyword{S4BuyseTest-method}
