% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-BuysePower-summary.R
\docType{methods}
\name{S4BuysePower-summary}
\alias{S4BuysePower-summary}
\alias{summary,S4BuysePower-method}
\title{Summary Method for Class "S4BuysePower"}
\usage{
\S4method{summary}{S4BuysePower}(
  object,
  print = TRUE,
  statistic = NULL,
  endpoint = NULL,
  order.Hprojection = NULL,
  transformation = NULL,
  legend = TRUE,
  col.rep = FALSE,
  digit = 4
)
}
\arguments{
\item{object}{output of \code{\link{powerBuyseTest}}}

\item{print}{[logical] Should the table be displayed?.}

\item{statistic}{[character] statistic relative to which the power should be computed:
\code{"netBenefit"} displays the net benefit, as described in Buyse (2010) and Peron et al. (2016)),
\code{"winRatio"} displays the win ratio, as described in Wang et al. (2016),
\code{"mannWhitney"} displays the proportion in favor of the treatment (also called Mann-Whitney parameter), as described in Fay et al. (2018).
Default value read from \code{BuyseTest.options()}.}

\item{endpoint}{[character vector] the endpoints to be displayed: must be the name of the endpoint followed by an underscore and then by the threshold.}

\item{order.Hprojection}{[integer 1,2] the order of the H-project to be used to compute the variance of the net benefit/win ratio.}

\item{transformation}{[logical] should the CI be computed on the logit scale / log scale for the net benefit / win ratio and backtransformed.}

\item{legend}{[logical] should explainations about the content of each column be displayed?}

\item{col.rep}{[logical] should the number of successful simulations be displayed?}

\item{digit}{[integer vector] the number of digit to use for printing the counts and the delta.}
}
\description{
Summarize the results from the \code{\link{powerBuyseTest}} function.
}
\references{
On the GPC procedure: Marc Buyse (2010). \bold{Generalized pairwise comparisons of prioritized endpoints in the two-sample problem}. \emph{Statistics in Medicine} 29:3245-3257 \cr
On the win ratio: D. Wang, S. Pocock (2016). \bold{A win ratio approach to comparing continuous non-normal outcomes in clinical trials}. \emph{Pharmaceutical Statistics} 15:238-245 \cr
On the Mann-Whitney parameter: Fay, Michael P. et al (2018). \bold{Causal estimands and confidence intervals asscoaited with Wilcoxon-Mann-Whitney tests in randomized experiments}. \emph{Statistics in Medicine} 37:2923-2937 \
}
\seealso{
\code{\link{powerBuyseTest}} for performing a simulation study for generalized pairwise comparison. \cr
}
\author{
Brice Ozenne
}
\keyword{S4BuysePower-method}
\keyword{summary}
