% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defineVariances.R
\name{defineVariances}
\alias{defineVariances}
\title{Define genetic, interaction, and error variances}
\usage{
defineVariances(sEnv = NULL, gVariance = 1, locCorrelations = NULL,
  gByLocVar = 1, gByYearVar = 1, fracGxEAdd = 0.8,
  plotTypeErrVars = c(Standard = 1))
}
\arguments{
\item{sEnv}{the environment that BSL functions operate in. Default is "simEnv" so use that to avoid specifying when calling functions}

\item{gVariance}{genetic variance in the initial population Default is 1}

\item{locCorrelations}{matrix: genetic correlation in performance between locations default: If given, the genetic co-variance across locations is gVariance * locCorrelations. If NULL, deviations with variance gByLocVar will be added to the main genotypic effect to determine the genotypic value in each location. The expected genetic correlation between locations is then gVariance / (gVariance + gByLocVar). Default is NULL}

\item{gByLocVar}{scalar: the genotype by location variance Default is 1, BUT if locCorrelations given, this parameter is not used)}

\item{gByYearVar}{scalar: the genotype by year variance Default is 1}

\item{fracGxEAdd}{scalar: for GxL and GxY what fraction of the effect is additive versus non-additive Default is 0.8}

\item{plotTypeErrVars}{named vector: names are the plot types and contents are the error variances associated with them (default: Standard=1)}
}
\value{
modifies the list sims in environment sEnv by adding parameters that determine genetic, location, year, and error variances
}
\description{
Define genetic, interaction, and error variances
}
