% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BranchGLMTable.R
\name{MultipleROCCurves}
\alias{MultipleROCCurves}
\title{Plotting Multiple ROC Curves}
\usage{
MultipleROCCurves(
  ...,
  legendpos = "bottomright",
  title = "ROC Curves",
  colors = NULL,
  names = NULL,
  lty = 1,
  lwd = 1
)
}
\arguments{
\item{...}{any number of \code{BranchGLMROC} objects.}

\item{legendpos}{a keyword to describe where to place the legend, such as "bottomright".
The default is "bottomright"}

\item{title}{title for the plot.}

\item{colors}{vector of colors to be used on the ROC curves.}

\item{names}{vector of names used to create a legend for the ROC curves.}

\item{lty}{vector of linetypes used to create the ROC curves or a 
single linetype to be used for all ROC curves.}

\item{lwd}{vector of linewidths used to create the ROC curves or a 
single linewidth to be used for all ROC curves.}
}
\value{
No return value, called to create the plot.
}
\description{
Plotting Multiple ROC Curves
}
\examples{
Data <- ToothGrowth

### Logistic ROC
LogisticFit <- BranchGLM(supp ~ ., data = Data, family = "binomial", link = "logit")
LogisticROC <- ROC(LogisticFit)

### Probit ROC
ProbitFit <- BranchGLM(supp ~ ., data = Data, family = "binomial", link = "probit")
ProbitROC <- ROC(ProbitFit)

### Cloglog ROC
CloglogFit <- BranchGLM(supp ~ ., data = Data, family = "binomial", link = "cloglog")
CloglogROC <- ROC(CloglogFit)

### Plotting ROC curves

MultipleROCCurves(LogisticROC, ProbitROC, CloglogROC, 
                  names = c("Logistic ROC", "Probit ROC", "Cloglog ROC"))

}
