% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableSelection.R
\name{predict.BranchGLMVS}
\alias{predict.BranchGLMVS}
\title{Predict Method for BranchGLMVS Objects}
\usage{
\method{predict}{BranchGLMVS}(object, newdata = NULL, type = "response", ...)
}
\arguments{
\item{object}{a \code{BranchGLMVS} object.}

\item{newdata}{a dataframe, if not specified the data the model was fit on is used.}

\item{type}{one of "linpreds" or "response", if not specified "response" is used.}

\item{...}{further arguments passed to \code{predict.BranchGLM}.}
}
\value{
A numeric vector of predictions.
}
\description{
Gets predictions from the best model found in the \code{BranchGLMVS} object.
}
\details{
linpreds corresponds to the linear predictors and response is on the scale of the response variable.
Offset variables are ignored for predictions on new data.
}
\examples{
Data <- iris
VS <- VariableSelection(Sepal.Length ~ ., data = Data, family = "gaussian", 
                        link = "identity", type = "branch and bound", showprogress = FALSE)
predict(VS)
### Example with new data
predict(VS, newdata = iris[1:20,])
}
