#' Simulation time series data for individual
#'
#' A dataset containing values of 10 interested
#' variables over 50 periods.
#'
#' @examples
#' ## Generated by the following R codes
#' set.seed(1000)
#' n = 50
#' p = 10
#' precision = diag(rep(2, p))        # generate precision matrix
#' for (i in 1 : (p - 1)){
#'   if (i <= 2 * p / 3) temp = 1
#'   if (i > 2 * p / 3) temp = 0.4
#'   precision[i, i + 1] = temp
#'   precision[i + 1, i] = temp
#' }
#' Sigma = solve(precision)           # generate covariance matrix
#' rho = 0.5
#' X = matrix(0, n, p)                # observed time series data
#' Epsilon = MASS::mvrnorm(n, rep(0, p), Sigma)
#' X[1, ] = Epsilon[1, ]
#' for (i in 2 : n){
#'   X[i, ] = rho * X[i - 1, ] + sqrt(1 - rho^2) * Epsilon[i, ]
#' }
#' indsim = X
"indsim"

#' Simulation time series data for population A
#'
#' A dataset containing values of 10 interested
#' variables of 20 subjects over 50 periods.
#' @seealso \code{\link{popsimB}}.
#' @examples
#' ## Generated by the following R codes
#' set.seed(1000)
#' n = 50
#' p = 10
#' m1 = 20; m2 = 15
#' precision1 = diag(rep(1, p))                  # generate precision matrix
#' for (i in 1 : (p - 1)){
#'   if (i <= 2 * p / 3) temp = -0.05
#'   if (i > 2 * p / 3) temp = -0.2
#'   precision1[i, i + 1] = temp
#'   precision1[i + 1, i] = temp
#' }
#' res = matrix(0, p, p)
#' for (i in 1 : p){
#'   for (j in 1 : p){
#'     if (abs(i - j) == 1) res[i, j] = 0.15
#'   }
#' }
#' precision2 = precision1 + res
#' Index0 = matrix(0, p, p)                     # generate covariance matrix
#' for (i in 1 : p){
#'   for (j in 1 : p){
#'     if (i != j & abs(i - j) <= 5) Index0[i, j] = 1
#'   }
#' }
#' SigmaAll1 = array(dim = c(p, p, m1))
#' SigmaAll2 = array(dim = c(p, p, m2))
#' for (sub in 1 : m1){
#'   RE = matrix(rnorm(p^2, 0, sqrt(2) * 0.05), p, p) * Index0
#'   RE1 = (RE + t(RE)) / 2
#'   precisionMatrixInd1 = precision1 + RE1
#'   SigmaInd1 = solve(precisionMatrixInd1)
#'   SigmaAll1[, , sub] = SigmaInd1
#' }
#' for (sub in 1 : m2){
#'   RE = matrix(rnorm(p^2, 0, sqrt(2) * 0.05), p, p) * Index0
#'   RE1 = (RE + t(RE)) / 2
#'   precisionMatrixInd2 = precision2 + RE1
#'   SigmaInd2 = solve(precisionMatrixInd2)
#'   SigmaAll2[, , sub] = SigmaInd2
#' }
#' rho = 0.5
#' Z1 = array(dim = c(n, p, m1))                # observed time series data
#' Z2 = array(dim = c(n, p, m2))
#' for (sub in 1 : m1){
#'   SigmaInd1 = SigmaAll1[, , sub]
#'   Xtemp = matrix(0, n, p)
#'   Epsilon = MASS::mvrnorm(n, rep(0, p), SigmaInd1)
#'   Xtemp[1, ] = Epsilon[1, ]
#'   for (i in 2 : n){
#'     Xtemp[i, ] = rho * Xtemp[i - 1, ] + sqrt(1 - rho^2) * Epsilon[i, ]
#'   }
#'   Z1[, , sub] = Xtemp
#' }
#' for (sub in 1 : m2){
#'   SigmaInd2 = SigmaAll2[, , sub]
#'   Xtemp = matrix(0, n, p)
#'   Epsilon = MASS::mvrnorm(n, rep(0, p), SigmaInd2)
#'   Xtemp[1, ] = Epsilon[1, ]
#'   for (i in 2 : n){
#'     Xtemp[i, ] = rho * Xtemp[i - 1, ] + sqrt(1 - rho^2) * Epsilon[i, ]
#'   }
#'   Z2[, , sub] = Xtemp
#' }
#' popsimA = Z1
#' popsimB = Z2
"popsimA"

#' Simulation time series data for population B
#'
#' A dataset containing values of 10 interested
#' variables of 15 subjects over 50 periods.
#'
#' @seealso \code{\link{popsimA}}.
"popsimB"
