% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blanket_statsments.R
\name{blanket_stats}
\alias{blanket_stats}
\title{Run multiple slightly different models of same type}
\usage{
blanket_stats(
  df,
  outcome,
  predictor_sets,
  covariates = c(),
  modality = "linear",
  event_censor = NA,
  verbose = FALSE
)
}
\arguments{
\item{df}{data.frame containing the data set.}

\item{outcome}{character designating the column with the outcome of interest}

\item{predictor_sets}{named list or character vectors containing columns with predictors}

\item{covariates}{vector of characters denoting columns with covariables}

\item{modality}{character denoting model type. Currently limited to 'linear', 'logistic', and 'cox'}

\item{event_censor}{character denoting column with censor event. For coxph models only}

\item{verbose}{logical. TRUE activates printout messages.}
}
\value{
named list of models
}
\description{
Run the same model (type, outcome, and covariates) with different sets of predictors
}
\examples{
data <- survival::lung
outcome <- 'time'
predictor_sets <- list('age' = c('age'),'age_ecog' = c('age', 'ph.ecog'))
covariates = c('sex')
modality <- 'cox'
event_censor <- 'status'
bl_stats <- blanket_stats(data, outcome, predictor_sets, covariates, modality, event_censor)

}
\author{
J. Peter Marquardt
}
