% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatFilter.R
\name{spatFilter}
\alias{spatFilter}
\title{Filters a set of points based on a probability map.}
\usage{
spatFilter(points, MAP, Nclass = FALSE)
}
\arguments{
\item{points}{data frame containing columns 'y' and 'x' (spatial coordinates on projected coordinate system).}

\item{MAP}{object of class RasterLayer. Map of probability [0;1] of a point to persist in any pixel.}

\item{Nclass}{optional number of classes into which MAP is going to be binned (quantile-based). This can be useful if the probability distribution of MAP is highly skewed.}
}
\value{
data frame with same structure as 'points' but with less rows (points).
}
\description{
This function rarefies a set of points using a raster map of probabilities of a point persisting in that location.
}
\author{
Luca Butikofer
}

