% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/436-extractDrugMannholdLogP.R
\name{extrDrugMannholdLogP}
\alias{extrDrugMannholdLogP}
\title{Descriptor that Calculates the LogP Based on a Simple Equation 
Using the Number of Carbons and Hetero Atoms}
\usage{
extrDrugMannholdLogP(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process 
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules, 
each column represents one feature. 
This function returns one column named \code{MLogP}.
}
\description{
Descriptor that Calculates the LogP Based on a Simple Equation 
Using the Number of Carbons and Hetero Atoms
}
\details{
This descriptor calculates the LogP based on a simple equation using 
the number of carbons and hetero atoms. 
The implemented equation was proposed in Mannhold et al.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugMannholdLogP(mol)
head(dat)

}
\references{
Mannhold, R., Poda, G. I., Ostermann, C., & Tetko, I. V. (2009). 
Calculation of molecular lipophilicity: State-of-the-art and 
comparison of log P methods on more than 96,000 compounds. 
Journal of pharmaceutical sciences, 98(3), 861-893.
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{LogP}
\keyword{Mannhold}
\keyword{extrDrugMannholdLogP}
