% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install.bioinfo}
\alias{install.bioinfo}
\title{Download and install biology software or database}
\usage{
install.bioinfo(name = c(), download.dir = c(), destdir = c(),
  name.saved = NULL, github.cfg = system.file("extdata",
  "config/github/github.toml", package = "BioInstaller"),
  nongithub.cfg = c(system.file("extdata", "config/nongithub/nongithub.toml",
  package = "BioInstaller"), system.file("extdata", "config/db/db_main.toml",
  package = "BioInstaller"), system.file("extdata", "config/db/db_annovar.toml",
  package = "BioInstaller"), system.file("extdata", "config/db/db_blast.toml",
  package = "BioInstaller")), version = c(), local.source = NULL,
  show.all.versions = FALSE, show.all.names = FALSE,
  db = Sys.getenv("BIO_SOFTWARES_DB_ACTIVE", system.file("extdata",
  "demo/softwares_db_demo.yaml", package = "BioInstaller")),
  download.only = FALSE, decompress = TRUE, dependence.need = TRUE,
  showWarnings = FALSE, extra.list = list(), rcmd.parse = TRUE,
  bash.parse = TRUE, glue.parse = TRUE, glue.flag = "!!glue",
  save.to.db = TRUE, license = "", overwrite = FALSE, verbose = TRUE,
  ...)
}
\arguments{
\item{name}{Software name}

\item{download.dir}{A string, point the source code download destdir}

\item{destdir}{A string, point the install path}

\item{name.saved}{Software name when you want to install different version, you
can use this to point the installed softwares name like 'GATK-3.7'}

\item{github.cfg}{Configuration file of installed by github url,
default is system.file('extdata', 'config/github/github.toml', package='BioInstaller')}

\item{nongithub.cfg}{Configuration file of installed by non github url,
default is c(system.file('extdata', 'config/nongithub/nongithub.toml', package = 'BioInstaller'),
system.file('extdata', 'config/db/db_main.toml', package = 'BioInstaller'), 
system.file('extdata', 'config/db/db_annovar.toml', package = 'BioInstaller'), 
system.file('extdata', 'config/db/db_blast.toml', package = 'BioInstaller'))}

\item{version}{Software version}

\item{local.source}{Install from local source, github softwares need a cloned dir, 
and nongithub softwares can be installed from a compressed file 
(if it is a dir, you need set decompress to FALSE)}

\item{show.all.versions}{Logical wheather show all avaliable versions can be install}

\item{show.all.names}{Logical wheather show all avaliable names can be install}

\item{db}{File of saving softwares infomation, default is Sys.getenv('BIO_SOFTWARES_DB_ACTIVE',
system.file('extdata', 'demo/softwares_db_demo.yaml', package = 'BioInstaller'))}

\item{download.only}{Logicol indicating wheather only download source or file (non-github)}

\item{decompress}{Logicol indicating wheather need to decompress the downloaded file, default is TRUE}

\item{dependence.need}{Logical should the dependence should be installed}

\item{showWarnings}{Logical should the warnings on failure be shown?}

\item{extra.list}{A list that can replace the configuration file '{{debug}}' by list(debug = TRUE), and {{debug}} will be setted to TRUE}

\item{rcmd.parse}{Logical wheather parse '@>@str_replace('abc', 'b', 'c')@<@' in config to 'acc'}

\item{bash.parse}{Logical wheather parse '#>#echo $HOME#<#' in config to your HOME PATH}

\item{glue.parse}{Logical wheather parse '!!glue{1:5}' in config to ['1','2','3','4','5']; 
['nochange', '!!glue(1:5)', 'nochange'] => ['nochange', '1', '2', '3', '4', '5', 'nochange']}

\item{glue.flag}{A character flage indicating wheater run glue() function to parse (Default is !!glue)}

\item{save.to.db}{Ligical indicating wheather save the install infomation in db}

\item{license}{The BioInstaller download license code.}

\item{overwrite}{Force delete the destdir or download dir without a interactive message (careful)}

\item{verbose}{Ligical indicating wheather show the log message}

\item{...}{Other key and value paired need be saved in BioInstaller passed to \code{\link{change.info}}}
}
\value{
Bool Value or a list
}
\description{
Download and install biology software or database
}
\examples{
db <- sprintf('\%s/.BioInstaller', tempdir())
set.biosoftwares.db(db)
tryCatch(install.bioinfo('bwa', show.all.versions = TRUE), 
error = function(e) {
  message('Connecting Github failed. Please try it again later.')
})
unlink(db)
}
