% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getinfo.R
\name{getvcfinfo}
\alias{getvcfinfo}
\title{Get information about a vcf file}
\usage{
getvcfinfo(vcffiles, gz = FALSE, index = TRUE, snpidformat = 0L)
}
\arguments{
\item{vcffiles}{A vector of file names.
The first is the name of the vcf file. The
second is name of the file that contains information
about the imputation of the SNPs. This file is produced
by minimac 3 and 4.}

\item{gz}{Indicator if VCF file is compressed using gzip.
Default value is FALSE.}

\item{index}{Indicator if file should be indexed. This
allows for faster reading of the file. Indexing a gzipped
file is not supported.
Default value is TRUE.}

\item{snpidformat}{The format that the SNP ID will be saved as.
0 - same as in the VCF file
1 - chromosome:location
2 - chromosome:location:referenceallele:alternateallele
If snpidformat is 1 and the VCF file uses format 2, an error is
generated. Default value is 0.}
}
\value{
List containing information about the VCF file
to include file name, subject IDs, and information about
the SNPs. Indices for faster reading will be included
if index is set to TRUE
}
\description{
Routine to return information about a vcf file.
This information is used by other routines to
allow for quicker extraction of values from the
file.
}
\examples{
# Get file names of th vcf and infromation file
vcf1afile <- system.file("extdata", "set1a.vcf", package = "BinaryDosage")
vcf1ainfo <- system.file("extdata", "set1a.info", package = "BinaryDosage")

# Get the information about the vcf file
vcf1ainfo <- getvcfinfo(vcffiles = c(vcf1afile, vcf1ainfo))
}
