% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consolidate.R
\name{consolidate}
\alias{consolidate}
\title{Consolidates replicate pairs in a binary matrix.}
\usage{
consolidate(x)
}
\arguments{
\item{x}{A CSV file containing replicate pairs of binary data. See the example input file "BinMatInput_reps".}
}
\value{
Consolidated binary matrix.
}
\description{
Reads in a binary matrix comprising replicate pairs and consolidates each pair into a consensus read. For each replicate pair at each locus, 1 & 1 -> 1 (shared presence), 0 & 0 -> 0 (shared absence), 0 & 1 -> ? (ambiguity).
}
\examples{
data(BinMatInput_reps)
mat = BinMatInput_reps
cons = consolidate(mat)

}
