% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BigVARSupportFunctions.R
\name{VarptoVar1MC}
\alias{VarptoVar1MC}
\title{Converts a VAR coefficient matrix of order p to multiple companion form}
\usage{
VarptoVar1MC(B, p, k)
}
\arguments{
\item{B}{a \eqn{k \times kp} coefficient matrix}

\item{p}{Lag order}

\item{k}{Number of Series}
}
\value{
Returns a \eqn{kp \times kp} coefficient matrix representing all coefficient matrices contained in Ai as a VAR(1).
}
\description{
Converts a VAR coefficient matrix of order p to multiple companion form
}
\examples{
k=3;p=6
B=matrix(0,nrow=k,ncol=p*k)
A1<- matrix(c(.4,-.02,.01,-.02,.3,.02,.01,.04,.3),ncol=3,nrow=3)
A2 <- matrix(c(.2,0,0,0,.3,0,0,0,.13),ncol=3,nrow=3)
B[,1:k]=A1
B[,(4*k+1):(5*k)]=A2
A <- VarptoVar1MC(B,p,k)
}
\references{
See page 15 of Lutkepohl, "A New Introduction to Multiple Time Series Analysis"
}
\seealso{
\code{\link{MultVarSim}}
}

