/*
 * Decompiled with CFR 0.152.
 */
package dr.xml;

import dr.util.XHTMLable;
import dr.xml.Reference;
import dr.xml.XMLParseException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class XMLObject {
    public static final String missingValue = "NA";
    public static final String ID = "id";
    private final Vector<Object> children = new Vector();
    private final Element element;
    private final XMLObject parent;
    private Object nativeObject;

    public XMLObject(Element element, XMLObject xMLObject) {
        this.element = element;
        this.parent = xMLObject;
    }

    public XMLObject(XMLObject xMLObject, int n) {
        this(xMLObject.element, null);
        this.nativeObject = ((List)xMLObject.getNativeObject()).get(n);
    }

    public final int getChildCount() {
        return this.children.size();
    }

    public Object getChild(int n) {
        Object object = this.getRawChild(n);
        XMLObject xMLObject = null;
        if (object instanceof XMLObject) {
            xMLObject = (XMLObject)object;
        } else if (object instanceof Reference) {
            xMLObject = ((Reference)object).getReferenceObject();
        }
        if (xMLObject != null && xMLObject.hasNativeObject()) {
            return xMLObject.getNativeObject();
        }
        return object;
    }

    public Object getChild(Class clazz) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Object object = this.getChild(i);
            if (!clazz.isInstance(object)) continue;
            return object;
        }
        return null;
    }

    public List<Object> getChildren() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Object object = this.getChild(i);
            arrayList.add(object);
        }
        return arrayList;
    }

    public <T> List<T> getAllChildren(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Object object = this.getChild(i);
            if (!clazz.isInstance(object)) continue;
            arrayList.add(clazz.cast(object));
        }
        return arrayList;
    }

    public XMLObject getChild(String string) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Object object = this.getChild(i);
            if (!(object instanceof XMLObject) || !((XMLObject)object).getName().equals(string)) continue;
            return (XMLObject)object;
        }
        return null;
    }

    public List<XMLObject> getAllChildren(String string) {
        ArrayList<XMLObject> arrayList = new ArrayList<XMLObject>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Object object = this.getChild(i);
            if (!(object instanceof XMLObject) || !((XMLObject)object).getName().equals(string)) continue;
            arrayList.add((XMLObject)object);
        }
        return arrayList;
    }

    public Object getElementFirstChild(String string) throws XMLParseException {
        XMLObject xMLObject = this.getChild(string);
        if (xMLObject == null) {
            throw new XMLParseException("Child element called " + string + " does not exist inside element " + this.getName());
        }
        if (!(xMLObject instanceof XMLObject)) {
            throw new XMLParseException("Child element called " + string + " inside element " + this.getName() + " is not an XMLObject.");
        }
        return xMLObject.getChild(0);
    }

    public String getChildName(int n) {
        XMLObject xMLObject;
        Object object = this.getRawChild(n);
        if (object instanceof XMLObject) {
            xMLObject = (XMLObject)object;
        } else if (object instanceof Reference) {
            xMLObject = ((Reference)object).getReferenceObject();
        } else {
            return "";
        }
        return xMLObject.getName();
    }

    public boolean hasChildNamed(String string) {
        XMLObject xMLObject = this.getChild(string);
        return xMLObject != null && xMLObject instanceof XMLObject;
    }

    public NamedNodeMap getAttributes() {
        return this.element.getAttributes();
    }

    public boolean getBooleanChild(int n) throws XMLParseException {
        return this.getBoolean(this.getChild(n));
    }

    public double getDoubleChild(int n) throws XMLParseException {
        return this.getDouble(this.getChild(n));
    }

    public double[] getDoubleArrayChild(int n) throws XMLParseException {
        return this.getDoubleArray(this.getChild(n));
    }

    public int getIntegerChild(int n) throws XMLParseException {
        return this.getInteger(this.getChild(n));
    }

    public String getStringChild(int n) throws XMLParseException {
        return this.getString(this.getChild(n));
    }

    public String[] getStringArrayChild(int n) throws XMLParseException {
        return this.getStringArray(this.getChild(n));
    }

    public <T> T getAttribute(String string, T t) throws XMLParseException {
        if (this.element.hasAttribute(string)) {
            String string2 = this.element.getAttribute(string);
            for (Constructor<?> constructor : t.getClass().getConstructors()) {
                Class<?>[] classArray = constructor.getParameterTypes();
                if (classArray.length != 1 || !classArray[0].equals(String.class)) continue;
                try {
                    return (T)constructor.newInstance(string2);
                }
                catch (Exception exception) {
                    throw new XMLParseException(" conversion of '" + string2 + "' to " + t.getClass().getName() + " failed");
                }
            }
        }
        return t;
    }

    public Object getAttribute(String string) throws XMLParseException {
        return this.getAndTest(string);
    }

    public boolean getBooleanAttribute(String string) throws XMLParseException {
        return this.getBoolean(this.getAndTest(string));
    }

    public boolean getBooleanAttribute(String string, boolean bl) throws XMLParseException {
        return this.getBoolean(this.getOrDefault(string, bl));
    }

    public double getDoubleAttribute(String string) throws XMLParseException {
        return this.getDouble(this.getAndTest(string));
    }

    public double getDoubleAttribute(String string, double d) throws XMLParseException {
        return this.getDouble(this.getOrDefault(string, d));
    }

    public double[] getDoubleArrayAttribute(String string) throws XMLParseException {
        return this.getDoubleArray(this.getAndTest(string));
    }

    public int[] getIntegerArrayAttribute(String string) throws XMLParseException {
        return this.getIntegerArray(this.getAndTest(string));
    }

    public int[] getIntegerArrayChild(int n) throws XMLParseException {
        return this.getIntegerArray(this.getChild(n));
    }

    public int getIntegerAttribute(String string) throws XMLParseException {
        return this.getInteger(this.getAndTest(string));
    }

    public int getIntegerAttribute(String string, int n) throws XMLParseException {
        return this.getInteger(this.getOrDefault(string, n));
    }

    public long getLongIntegerAttribute(String string) throws XMLParseException {
        return this.getLongInteger(this.getAndTest(string));
    }

    public long getLongIntegerAttribute(String string, long l) throws XMLParseException {
        return this.getLongInteger(this.getOrDefault(string, l));
    }

    public String getStringAttribute(String string) throws XMLParseException {
        return this.getString(this.getAndTest(string));
    }

    public String getStringAttribute(String string, String string2) throws XMLParseException {
        return this.getString(this.getOrDefault(string, string2));
    }

    public String[] getStringArrayAttribute(String string) throws XMLParseException {
        return this.getStringArray(this.getAndTest(string));
    }

    public static boolean isDoubleArray(String string, List<Double> list) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Double d = string2.compareToIgnoreCase(missingValue) == 0 ? Double.valueOf(Double.NaN) : Double.valueOf(Double.parseDouble(string2));
                if (list == null) continue;
                list.add(d);
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isIntegerArray(String string, List<Integer> list) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                Integer n = Integer.parseInt(stringTokenizer.nextToken());
                if (list == null) continue;
                list.add(n);
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean hasId() {
        return this.hasAttribute(ID);
    }

    public String getId() throws XMLParseException {
        return this.getStringAttribute(ID);
    }

    public boolean hasAttribute(String string) {
        return this.element.hasAttribute(string);
    }

    public String getName() {
        return this.element.getTagName();
    }

    public Object getNativeObject() {
        return this.nativeObject;
    }

    public boolean hasNativeObject() {
        return this.nativeObject != null;
    }

    public String toString() {
        String string;
        block3: {
            string = this.getName();
            if (this.hasId()) {
                try {
                    string = string + ":" + this.getId();
                }
                catch (XMLParseException xMLParseException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return string;
    }

    public String content() {
        if (this.nativeObject != null) {
            if (this.nativeObject instanceof XHTMLable) {
                return ((XHTMLable)this.nativeObject).toXHTML();
            }
            return this.nativeObject.toString();
        }
        return "";
    }

    void addChild(Object object) {
        if (!(object instanceof XMLObject || object instanceof Reference || object instanceof String)) {
            throw new IllegalArgumentException();
        }
        this.children.add(object);
    }

    public Object getRawChild(int n) {
        return this.children.get(n);
    }

    public void setNativeObject(Object object) {
        this.nativeObject = object;
    }

    boolean isReference(int n) {
        return this.getRawChild(n) instanceof Reference;
    }

    private boolean getBoolean(Object object) throws XMLParseException {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            if (object.equals("true")) {
                return true;
            }
            if (object.equals("false")) {
                return false;
            }
        }
        throw new XMLParseException("Expected a boolean (true|false), but got " + object);
    }

    private double getDouble(Object object) throws XMLParseException {
        try {
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            if (object instanceof String) {
                return Double.parseDouble((String)object);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLParseException("Expected double precision number, but got " + object);
        }
        throw new XMLParseException("Expected double precision number, but got " + object);
    }

    private double[] getDoubleArray(Object object) throws XMLParseException {
        if (object instanceof Number) {
            return new double[]{((Number)object).doubleValue()};
        }
        if (object instanceof double[]) {
            return (double[])object;
        }
        if (object instanceof String) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            if (XMLObject.isDoubleArray((String)object, arrayList)) {
                double[] dArray = new double[arrayList.size()];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = (Double)arrayList.get(i);
                }
                return dArray;
            }
            throw new XMLParseException("Expected array of double precision numbers, but got " + object);
        }
        throw new XMLParseException("Expected array of double precision numbers, but got " + object);
    }

    private int[] getIntegerArray(Object object) throws XMLParseException {
        if (object instanceof Number) {
            return new int[]{((Number)object).intValue()};
        }
        if (object instanceof int[]) {
            return (int[])object;
        }
        if (object instanceof String) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            if (XMLObject.isIntegerArray((String)object, arrayList)) {
                int[] nArray = new int[arrayList.size()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = arrayList.get(i);
                }
                return nArray;
            }
            throw new XMLParseException("Expected array of integers, but got " + object);
        }
        throw new XMLParseException("Expected array of integers, but got " + object);
    }

    private int getInteger(Object object) throws XMLParseException {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            return Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLParseException("Expected integer, got " + object);
        }
    }

    private long getLongInteger(Object object) throws XMLParseException {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        try {
            return Long.parseLong((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLParseException("Expected long integer, got " + object);
        }
    }

    private String getString(Object object) throws XMLParseException {
        if (object instanceof String) {
            return (String)object;
        }
        throw new XMLParseException("Expected string, but got " + object);
    }

    private String[] getStringArray(Object object) throws XMLParseException {
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object instanceof String) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer((String)object);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            String[] stringArray = new String[arrayList.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
            return stringArray;
        }
        throw new XMLParseException("Expected array of strings, but got " + object);
    }

    private Object getAndTest(String string) throws XMLParseException {
        if (this.element.hasAttribute(string)) {
            return this.element.getAttribute(string);
        }
        throw new XMLParseException("'" + string + "' attribute was not found in " + this.element.getTagName() + " element.");
    }

    private Object getOrDefault(String string, Object object) throws XMLParseException {
        if (this.element.hasAttribute(string)) {
            return this.element.getAttribute(string);
        }
        return object;
    }

    public XMLObject getParent() {
        return this.parent;
    }
}

