/*
 * Decompiled with CFR 0.152.
 */
package dr.xml;

import dr.app.beast.BeastParser;
import dr.app.tools.BeastParserDoc;
import dr.xml.ClassComparator;
import dr.xml.XMLDocumentationHandler;
import dr.xml.XMLObjectParser;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TreeSet;

public class WikiDocumentationHandler
extends XMLDocumentationHandler {
    private static final String WIKILINK = "[[Main Page|BEAST Documentation]]-> BEAST v1.5.x XML Reference";

    public WikiDocumentationHandler(BeastParser beastParser) {
        super(beastParser);
    }

    @Override
    public void outputElements(PrintWriter printWriter) {
        this.printDocWikiTitle(printWriter);
        Iterator iterator = this.parser.getParsers();
        while (iterator.hasNext()) {
            XMLObjectParser xMLObjectParser = (XMLObjectParser)iterator.next();
            printWriter.println(xMLObjectParser.toWiki(this));
            System.out.println("  outputting Wiki for element " + xMLObjectParser.getParserName());
        }
    }

    private void printDocWikiTitle(PrintWriter printWriter) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("'updated on' d MMMM yyyy zzz");
        printWriter.println("[[Main Page|BEAST Documentation]]-> BEAST v1.5.x XML Reference\n");
        printWriter.println("==" + BeastParserDoc.TITLE + "==\n");
        if (this.parser.parsers != null) {
            if (this.parser.parsers.equalsIgnoreCase("release")) {
                printWriter.println("Release Version (" + simpleDateFormat.format(calendar.getTime()) + ")");
                System.out.println("Release Version");
            } else if (this.parser.parsers.equalsIgnoreCase("development")) {
                printWriter.println("Development Version (" + simpleDateFormat.format(calendar.getTime()) + ")");
                System.out.println("Development Version");
            }
        }
        printWriter.println("");
        printWriter.println("The following is a list of valid elements in a beast file.");
        printWriter.println("");
    }

    @Override
    public void outputTypes(PrintWriter printWriter) {
        printWriter.println("==BEAST types==");
        printWriter.println("");
        printWriter.println("The following is a list of generic types that elements represent in a beast file.");
        printWriter.println("");
        for (Class clazz : this.requiredTypes) {
            if (clazz == Object.class) continue;
            String string = ClassComparator.getName(clazz);
            System.out.println("  outputting Wiki for generic type " + string);
            TreeSet<String> treeSet = new TreeSet<String>();
            Iterator iterator = this.parser.getParsers();
            while (iterator.hasNext()) {
                XMLObjectParser xMLObjectParser = (XMLObjectParser)iterator.next();
                Class clazz2 = xMLObjectParser.getReturnType();
                if (!clazz.isAssignableFrom(clazz2)) continue;
                treeSet.add(xMLObjectParser.getParserName());
            }
            if (treeSet.size() == 1 && ((String)treeSet.iterator().next()).equals(string)) continue;
            printWriter.println("===" + string + "===");
            printWriter.println();
            printWriter.println("Elements of this type include:");
            printWriter.println();
            for (String string2 : treeSet) {
                printWriter.println(":*" + this.getWikiLink(string2));
            }
            printWriter.println();
        }
    }

    @Override
    public String getHTMLForClass(Class clazz) {
        return this.getWikiLink(ClassComparator.getName(clazz));
    }

    public String getWikiLink(String string) {
        if (Character.isUpperCase(string.charAt(0))) {
            return "[[#" + string + "|" + string + "]]";
        }
        return "[[#&lt;" + string + "&gt; element|" + string + "]]";
    }
}

