/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.IntersectionBounds;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class EqualityConstrainedParameter
extends Parameter.Abstract
implements VariableListener {
    public static final String EQUALITY_CONSTRAINED_PARAMETER = "constrainedEqualParameter";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Parameter.class, 2, Integer.MAX_VALUE)};

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n = -1;
            double[] dArray = null;
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                Parameter parameter = (Parameter)xMLObject.getChild(i);
                if (i == 0) {
                    n = parameter.getDimension();
                    dArray = parameter.getParameterValues();
                } else {
                    if (parameter.getDimension() != n) {
                        throw new XMLParseException("All parameters must have the same dimension.");
                    }
                    for (int j = 0; j < n; ++j) {
                        parameter.setParameterValue(j, dArray[j]);
                    }
                }
                arrayList.add(parameter);
            }
            return new EqualityConstrainedParameter(xMLObject.getId(), arrayList);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Forces a set of parameters to have equal values";
        }

        @Override
        public Class getReturnType() {
            return EqualityConstrainedParameter.class;
        }

        @Override
        public String getParserName() {
            return EqualityConstrainedParameter.EQUALITY_CONSTRAINED_PARAMETER;
        }
    };
    private final List<Parameter> uniqueParameters;
    private final Bounds bounds;
    private int dimension;
    private boolean isLocked = false;

    public EqualityConstrainedParameter(String string, List<Parameter> list) {
        super(string);
        this.uniqueParameters = list;
        this.dimension = this.uniqueParameters.get(0).getDimension();
        this.bounds = this.makeIntersectionBounds();
        for (Parameter parameter : list) {
            parameter.addParameterListener(this);
            for (Parameter parameter2 : list) {
                if (parameter == parameter2) continue;
                parameter.addBounds(parameter2.getBounds());
            }
        }
        StringBuilder stringBuilder = new StringBuilder("Constraining multiple parameters to be equal: ");
        stringBuilder.append(this.getId()).append("\n");
        Logger.getLogger("dr.inference.model").info(stringBuilder.toString());
    }

    @Override
    public final String getParameterName() {
        return this.getId();
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public void setDimension(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bounds<Double> getBounds() {
        return this.bounds;
    }

    private Bounds<Double> makeIntersectionBounds() {
        IntersectionBounds intersectionBounds = new IntersectionBounds(this.dimension);
        for (Parameter parameter : this.uniqueParameters) {
            intersectionBounds.addBounds(parameter.getBounds());
        }
        return intersectionBounds;
    }

    @Override
    public void addDimension(int n, double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double removeDimension(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getParameterValue(int n) {
        return this.uniqueParameters.get(0).getParameterValue(n);
    }

    @Override
    public void setParameterValue(int n, double d) {
        this.isLocked = true;
        for (Parameter parameter : this.uniqueParameters) {
            parameter.setParameterValue(n, d);
        }
        this.isLocked = false;
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        this.isLocked = true;
        for (Parameter parameter : this.uniqueParameters) {
            parameter.setParameterValueQuietly(n, d);
        }
        this.isLocked = false;
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        this.isLocked = true;
        for (Parameter parameter : this.uniqueParameters) {
            parameter.setParameterValueNotifyChangedAll(n, d);
        }
        this.isLocked = false;
    }

    @Override
    protected void storeValues() {
        for (Parameter parameter : this.uniqueParameters) {
            parameter.storeParameterValues();
        }
    }

    @Override
    protected void restoreValues() {
        for (Parameter parameter : this.uniqueParameters) {
            parameter.restoreParameterValues();
        }
    }

    @Override
    protected final void acceptValues() {
        for (Parameter parameter : this.uniqueParameters) {
            parameter.acceptParameterValues();
        }
    }

    @Override
    protected final void adoptValues(Parameter parameter) {
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (!this.isLocked) {
            Parameter parameter = (Parameter)variable;
            if (changeType == Variable.ChangeType.ALL_VALUES_CHANGED) {
                double[] dArray = parameter.getParameterValues();
                for (Parameter parameter2 : this.uniqueParameters) {
                    if (parameter2 == parameter) continue;
                    for (int i = 1; i < dArray.length; ++i) {
                        this.isLocked = true;
                        parameter2.setParameterValueQuietly(i, dArray[i]);
                        this.isLocked = false;
                    }
                    this.isLocked = true;
                    parameter2.setParameterValueNotifyChangedAll(0, dArray[0]);
                    this.isLocked = false;
                }
            } else if (changeType == Variable.ChangeType.VALUE_CHANGED) {
                double d = parameter.getParameterValue(n);
                for (Parameter parameter3 : this.uniqueParameters) {
                    if (parameter3 == parameter) continue;
                    this.isLocked = true;
                    parameter3.setParameterValue(n, d);
                    this.isLocked = false;
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }
}

