/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.evomodel.substmodel.CovarionFrequencyModel;
import dr.evomodel.substmodel.DefaultEigenSystem;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.substmodel.EigenSystem;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.Arrays;

public abstract class BaseSubstitutionModel
extends AbstractModel
implements SubstitutionModel {
    public static final String MODEL = "model";
    protected DataType dataType = null;
    protected FrequencyModel freqModel;
    protected double[] relativeRates;
    protected double[] storedRelativeRates;
    protected int stateCount;
    protected int rateCount;
    protected boolean updateMatrix = true;
    protected boolean storedUpdateMatrix = true;
    private final EigenSystem eigenSystem;
    static String format = "%2.1e";
    private final double[][] q;
    protected EigenDecomposition eigenDecomposition;
    private EigenDecomposition storedEigenDecomposition;

    public BaseSubstitutionModel(String string) {
        super(string);
        this.eigenSystem = null;
        this.q = null;
    }

    public BaseSubstitutionModel(String string, DataType dataType, FrequencyModel frequencyModel) {
        this(string, dataType, frequencyModel, null);
    }

    public BaseSubstitutionModel(String string, DataType dataType, FrequencyModel frequencyModel, EigenSystem eigenSystem) {
        super(string);
        this.eigenSystem = eigenSystem == null ? this.getDefaultEigenSystem(dataType.getStateCount()) : eigenSystem;
        this.dataType = dataType;
        this.setStateCount(dataType.getStateCount());
        if (frequencyModel != null) {
            if (frequencyModel.getDataType() != dataType) {
                throw new IllegalArgumentException("Datatypes do not match.");
            }
            this.freqModel = frequencyModel;
            this.addModel(frequencyModel);
            if (!(frequencyModel instanceof CovarionFrequencyModel)) {
                this.checkFrequencies();
            }
        }
        this.q = new double[this.stateCount][this.stateCount];
        this.updateMatrix = true;
    }

    protected EigenSystem getDefaultEigenSystem(int n) {
        return new DefaultEigenSystem(n);
    }

    private void setStateCount(int n) {
        this.stateCount = n;
        this.rateCount = this.getRateCount(n);
        this.relativeRates = new double[this.rateCount];
        this.storedRelativeRates = new double[this.rateCount];
        for (int i = 0; i < this.rateCount; ++i) {
            this.relativeRates[i] = 1.0;
        }
    }

    protected int getRateCount(int n) {
        return (n - 1) * n / 2;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.updateMatrix = true;
        this.frequenciesChanged();
        this.fireModelChanged();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.updateMatrix = true;
        this.ratesChanged();
    }

    @Override
    protected void storeState() {
        this.storedUpdateMatrix = this.updateMatrix;
        System.arraycopy(this.relativeRates, 0, this.storedRelativeRates, 0, this.rateCount);
        if (this.eigenDecomposition != null) {
            this.storedEigenDecomposition = this.eigenDecomposition.copy();
        }
    }

    @Override
    protected void restoreState() {
        this.updateMatrix = this.storedUpdateMatrix;
        double[] dArray = this.storedRelativeRates;
        this.storedRelativeRates = this.relativeRates;
        this.relativeRates = dArray;
        EigenDecomposition eigenDecomposition = this.storedEigenDecomposition;
        this.storedEigenDecomposition = this.eigenDecomposition;
        this.eigenDecomposition = eigenDecomposition;
    }

    @Override
    protected void acceptState() {
    }

    protected abstract void frequenciesChanged();

    protected abstract void ratesChanged();

    protected abstract void setupRelativeRates(double[] var1);

    @Override
    public FrequencyModel getFrequencyModel() {
        return this.freqModel;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public void getTransitionProbabilities(double d, double[] dArray) {
        int n;
        double d2;
        int n2;
        EigenDecomposition eigenDecomposition = this.getEigenDecomposition();
        if (eigenDecomposition == null) {
            Arrays.fill(dArray, 0.0);
            return;
        }
        double[] dArray2 = eigenDecomposition.getEigenVectors();
        double[] dArray3 = eigenDecomposition.getInverseEigenVectors();
        double[] dArray4 = eigenDecomposition.getEigenValues();
        double[][] dArray5 = new double[this.stateCount][this.stateCount];
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            d2 = Math.exp(d * dArray4[n2]);
            for (n = 0; n < this.stateCount; ++n) {
                dArray5[n2][n] = dArray3[n2 * this.stateCount + n] * d2;
            }
        }
        n2 = 0;
        for (n = 0; n < this.stateCount; ++n) {
            for (int i = 0; i < this.stateCount; ++i) {
                d2 = 0.0;
                for (int j = 0; j < this.stateCount; ++j) {
                    d2 += dArray2[n * this.stateCount + j] * dArray5[j][i];
                }
                dArray[n2] = Math.abs(d2);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EigenDecomposition getEigenDecomposition() {
        BaseSubstitutionModel baseSubstitutionModel = this;
        synchronized (baseSubstitutionModel) {
            if (this.updateMatrix) {
                this.decompose();
            }
        }
        return this.eigenDecomposition;
    }

    protected void setupQMatrix(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n = 0;
        for (int i = 0; i < this.stateCount; ++i) {
            for (int j = i + 1; j < this.stateCount; ++j) {
                dArray3[i][j] = dArray[n] * dArray2[j];
                dArray3[j][i] = dArray[n] * dArray2[i];
                ++n;
            }
        }
    }

    private void decompose() {
        double d = this.setupMatrix();
        this.eigenDecomposition = this.eigenSystem.decomposeMatrix(this.q);
        if (this.eigenDecomposition != null) {
            this.eigenDecomposition.normalizeEigenValues(d);
        }
        this.updateMatrix = false;
    }

    protected double setupMatrix() {
        this.setupRelativeRates(this.relativeRates);
        double[] dArray = this.getPi();
        this.setupQMatrix(this.relativeRates, dArray, this.q);
        this.makeValid(this.q, this.stateCount);
        return this.getNormalizationValue(this.q, dArray);
    }

    protected double[] getPi() {
        return this.freqModel.getFrequencies();
    }

    @Override
    public void getInfinitesimalMatrix(double[] dArray) {
        double d = this.setupMatrix();
        int n = 0;
        for (int i = 0; i < this.stateCount; ++i) {
            for (int j = 0; j < this.stateCount; ++j) {
                dArray[n] = this.q[i][j] / d;
                ++n;
            }
        }
    }

    protected double getNormalizationValue(double[][] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < this.stateCount; ++i) {
            d += -dArray[i][i] * dArray2[i];
        }
        return d;
    }

    public String printQ() {
        double[] dArray = new double[this.stateCount * this.stateCount];
        this.getInfinitesimalMatrix(dArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < this.stateCount; ++i) {
            if (i > 0) {
                stringBuffer.append(String.format(format, dArray[n]));
            }
            for (int j = 1; j < this.stateCount; ++j) {
                stringBuffer.append("\t");
                if (j != i) {
                    stringBuffer.append(String.format(format, dArray[n]));
                }
                ++n;
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    protected void makeValid(double[][] dArray, int n) {
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                d += dArray[i][j];
            }
            dArray[i][i] = -d;
        }
    }

    private void checkFrequencies() {
        double d = this.getMINFDIFF();
        double d2 = this.getMINFREQ();
        int n = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.stateCount; ++i) {
            double d5 = this.freqModel.getFrequency(i);
            if (d5 < d2) {
                this.freqModel.setFrequency(i, d2);
            }
            if (d5 > d4) {
                d4 = d5;
                n = i;
            }
            d3 += this.freqModel.getFrequency(i);
        }
        double d6 = 1.0 - d3;
        this.freqModel.setFrequency(n, this.freqModel.getFrequency(n) + d6);
        for (int i = 0; i < this.stateCount - 1; ++i) {
            for (int j = i + 1; j < this.stateCount; ++j) {
                if (this.freqModel.getFrequency(i) != this.freqModel.getFrequency(j)) continue;
                this.freqModel.setFrequency(i, this.freqModel.getFrequency(i) + d);
                this.freqModel.setFrequency(j, this.freqModel.getFrequency(j) - d);
            }
        }
    }

    @Override
    public boolean canReturnComplexDiagonalization() {
        return false;
    }

    protected double getMINFDIFF() {
        return 1.0E-10;
    }

    protected double getMINFREQ() {
        return 1.0E-10;
    }

    protected double[][] getQCopy() {
        double[][] dArray = new double[this.q.length][this.q.length];
        for (int i = 0; i < this.q.length; ++i) {
            System.arraycopy(this.q[i], 0, dArray[i], 0, this.q.length);
        }
        return dArray;
    }
}

