/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.siteratemodel;

import dr.evomodel.siteratemodel.HomogeneousRateDelegate;
import dr.evomodel.siteratemodel.SiteRateDelegate;
import dr.evomodel.siteratemodel.SiteRateModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import java.util.Arrays;
import java.util.Comparator;

public class DiscretizedSiteRateModel
extends AbstractModel
implements SiteRateModel {
    private final Statistic muStatistic = new Statistic.Abstract(){

        @Override
        public String getStatisticName() {
            return "mu";
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public String getDimensionName(int n) {
            return this.getId();
        }

        @Override
        public double getStatisticValue(int n) {
            return DiscretizedSiteRateModel.this.getMu();
        }
    };
    private final Statistic ratesStatistic = new Statistic.Abstract(){

        @Override
        public String getStatisticName() {
            return "rates";
        }

        @Override
        public int getDimension() {
            return DiscretizedSiteRateModel.this.getCategoryCount();
        }

        @Override
        public double getStatisticValue(int n) {
            if (!DiscretizedSiteRateModel.this.orderedRatesKnown) {
                DiscretizedSiteRateModel.this.calculateOrderedCategories();
            }
            return DiscretizedSiteRateModel.this.orderedCategories[n][0];
        }
    };
    private final Statistic weightsStatistic = new Statistic.Abstract(){

        @Override
        public String getStatisticName() {
            return "weights";
        }

        @Override
        public int getDimension() {
            return DiscretizedSiteRateModel.this.getCategoryCount();
        }

        @Override
        public double getStatisticValue(int n) {
            if (!DiscretizedSiteRateModel.this.orderedRatesKnown) {
                DiscretizedSiteRateModel.this.calculateOrderedCategories();
            }
            return DiscretizedSiteRateModel.this.orderedCategories[n][1];
        }
    };
    private final Parameter nuParameter;
    private final double muWeight;
    private boolean ratesKnown;
    private boolean orderedRatesKnown;
    private final double[] categoryRates;
    private final double[][] orderedCategories;
    private final double[] categoryProportions;
    private final SiteRateDelegate delegate;
    private SubstitutionModel substitutionModel;

    public DiscretizedSiteRateModel(String string) {
        this(string, null, 0.0, new HomogeneousRateDelegate(null));
    }

    public DiscretizedSiteRateModel(String string, Parameter parameter, double d) {
        this(string, parameter, d, new HomogeneousRateDelegate(null));
    }

    public DiscretizedSiteRateModel(String string, Parameter parameter, double d, SiteRateDelegate siteRateDelegate) {
        super(string);
        this.nuParameter = parameter;
        if (parameter != null) {
            this.addVariable(parameter);
            parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        }
        this.muWeight = d;
        this.addStatistic(this.muStatistic);
        this.addStatistic(this.ratesStatistic);
        this.addStatistic(this.weightsStatistic);
        this.delegate = siteRateDelegate;
        this.addModel(siteRateDelegate);
        this.categoryRates = new double[siteRateDelegate.getCategoryCount()];
        this.categoryProportions = new double[siteRateDelegate.getCategoryCount()];
        this.orderedCategories = new double[siteRateDelegate.getCategoryCount()][2];
        this.ratesKnown = false;
        this.orderedRatesKnown = false;
    }

    public void setMu(double d) {
        this.nuParameter.setParameterValue(0, d / this.muWeight);
    }

    public final double getMu() {
        return this.nuParameter.getParameterValue(0) * this.muWeight;
    }

    @Override
    public int getCategoryCount() {
        return this.delegate.getCategoryCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getCategoryRates() {
        DiscretizedSiteRateModel discretizedSiteRateModel = this;
        synchronized (discretizedSiteRateModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        return this.categoryRates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getCategoryProportions() {
        DiscretizedSiteRateModel discretizedSiteRateModel = this;
        synchronized (discretizedSiteRateModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        return this.categoryProportions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRateForCategory(int n) {
        DiscretizedSiteRateModel discretizedSiteRateModel = this;
        synchronized (discretizedSiteRateModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        return this.categoryRates[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getProportionForCategory(int n) {
        DiscretizedSiteRateModel discretizedSiteRateModel = this;
        synchronized (discretizedSiteRateModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        return this.categoryProportions[n];
    }

    private void calculateCategoryRates() {
        this.delegate.getCategories(this.categoryRates, this.categoryProportions);
        if (this.nuParameter != null) {
            double d = this.getMu();
            int n = 0;
            while (n < this.getCategoryCount()) {
                int n2 = n++;
                this.categoryRates[n2] = this.categoryRates[n2] * d;
            }
        }
        this.ratesKnown = true;
        this.orderedRatesKnown = false;
    }

    private void calculateOrderedCategories() {
        for (int i = 0; i < this.categoryRates.length; ++i) {
            this.orderedCategories[i][0] = this.categoryRates[i];
            this.orderedCategories[i][1] = this.categoryProportions[i];
        }
        Arrays.sort(this.orderedCategories, Comparator.comparingDouble(dArray -> dArray[1]));
        this.orderedRatesKnown = true;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.ratesKnown = false;
        this.listenerHelper.fireModelChanged(this, object, n);
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.ratesKnown = false;
        this.listenerHelper.fireModelChanged(this, variable, n);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.ratesKnown = false;
    }

    @Override
    protected void acceptState() {
    }

    public SubstitutionModel getSubstitutionModel() {
        return this.substitutionModel;
    }

    public void setSubstitutionModel(SubstitutionModel substitutionModel) {
        this.substitutionModel = substitutionModel;
    }
}

