/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.tree.DefaultTreeModel;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RateExchangeOperator
extends SimpleMCMCOperator {
    private static final String TRAIT = "trait";
    private final DefaultTreeModel tree;
    private final boolean swapRates;
    private final boolean swapTraits;
    private final boolean swapAtRoot;
    private final boolean moveHeight;

    public RateExchangeOperator(DefaultTreeModel defaultTreeModel, double d, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.tree = defaultTreeModel;
        this.setWeight(d);
        this.swapRates = bl;
        this.swapTraits = bl2;
        this.swapAtRoot = bl3;
        this.moveHeight = bl4;
    }

    @Override
    public double doOperation() {
        int n;
        int n2;
        double[] dArray;
        NodeRef nodeRef = this.tree.getInternalNode(MathUtils.nextInt(this.tree.getInternalNodeCount()));
        NodeRef nodeRef2 = this.tree.getChild(nodeRef, 0);
        NodeRef nodeRef3 = this.tree.getChild(nodeRef, 1);
        if (this.swapRates) {
            if (this.swapAtRoot) {
                dArray = new double[]{this.tree.getNodeRate(nodeRef), this.tree.getNodeRate(nodeRef2), this.tree.getNodeRate(nodeRef3)};
                n2 = MathUtils.nextInt(3);
                this.tree.setNodeRate(nodeRef, dArray[n2]);
                dArray[n2] = dArray[2];
                n = MathUtils.nextInt(2);
                this.tree.setNodeRate(nodeRef2, dArray[n]);
                dArray[n] = dArray[1];
                this.tree.setNodeRate(nodeRef3, dArray[0]);
            } else {
                double d = this.tree.getNodeRate(nodeRef2);
                this.tree.setNodeRate(nodeRef2, this.tree.getNodeRate(nodeRef3));
                this.tree.setNodeRate(nodeRef3, d);
            }
        }
        if (this.swapTraits) {
            if (this.swapAtRoot) {
                dArray = new double[]{this.tree.getNodeTrait(nodeRef, TRAIT), this.tree.getNodeTrait(nodeRef2, TRAIT), this.tree.getNodeTrait(nodeRef3, TRAIT)};
                n2 = MathUtils.nextInt(3);
                this.tree.setNodeTrait(nodeRef, TRAIT, dArray[n2]);
                dArray[n2] = dArray[2];
                n = MathUtils.nextInt(2);
                this.tree.setNodeTrait(nodeRef2, TRAIT, dArray[n]);
                dArray[n] = dArray[1];
                this.tree.setNodeTrait(nodeRef3, TRAIT, dArray[0]);
            } else {
                double d = this.tree.getNodeTrait(nodeRef2, TRAIT);
                this.tree.setNodeTrait(nodeRef2, TRAIT, this.tree.getNodeTrait(nodeRef3, TRAIT));
                this.tree.setNodeTrait(nodeRef3, TRAIT, d);
            }
        }
        if (!this.tree.isRoot(nodeRef) && this.moveHeight) {
            double d = this.tree.getNodeHeightLower(nodeRef);
            double d2 = this.tree.getNodeHeightUpper(nodeRef);
            double d3 = MathUtils.nextDouble() * (d2 - d) + d;
            this.tree.setNodeHeight(nodeRef, d3);
        }
        return 0.0;
    }

    public double getTargetAcceptanceProbability() {
        return 0.234;
    }

    @Override
    public String getOperatorName() {
        return "rateExchange";
    }

    public Element createOperatorElement(Document document) {
        return document.createElement("rateExchange");
    }
}

