/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.alignment.PatternList;
import dr.evolution.datatype.TwoStates;
import dr.evolution.tree.NodeRef;
import dr.evomodel.continuous.AbstractMultivariateTraitLikelihood;
import dr.evomodel.continuous.LatentTruncation;
import dr.evomodel.continuous.SoftThresholdLikelihood;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.Distribution;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class BinaryLatentLiabilityLikelihood
extends AbstractModelLikelihood
implements LatentTruncation,
Citable,
SoftThresholdLikelihood {
    public static final String LATENT_LIABILITY_LIKELIHOOD = "latentLiabilityLikelihood";
    private final LatentTruncation.Delegate normalizationDelegate = new LatentTruncation.Delegate(){

        @Override
        protected double computeNormalizationConstant(Distribution distribution) {
            double d = 0.0;
            return d;
        }
    };
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String TIP_TRAIT = "tipTrait";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(AbstractMultivariateTraitLikelihood.class, "The model for the latent random variables"), new ElementRule("tipTrait", CompoundParameter.class, "The parameter of tip locations from the tree"), new ElementRule(PatternList.class, "The binary tip data"), new ElementRule(TreeModel.class, "The tree model")};

        @Override
        public String getParserName() {
            return BinaryLatentLiabilityLikelihood.LATENT_LIABILITY_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood = (AbstractMultivariateTraitLikelihood)xMLObject.getChild(AbstractMultivariateTraitLikelihood.class);
            PatternList patternList = (PatternList)xMLObject.getChild(PatternList.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            CompoundParameter compoundParameter = (CompoundParameter)xMLObject.getElementFirstChild(TIP_TRAIT);
            int n = treeModel.getTaxonCount();
            int n2 = abstractMultivariateTraitLikelihood.getNumData();
            int n3 = abstractMultivariateTraitLikelihood.getDimTrait();
            if (compoundParameter.getDimension() != n * n2 * n3) {
                throw new XMLParseException("Tip trait parameter is wrong dimension in latent liability model");
            }
            if (!(patternList.getDataType() instanceof TwoStates)) {
                throw new XMLParseException("Latent liability model currently only works for binary data");
            }
            if (patternList.getPatternCount() != n2 * n3) {
                throw new XMLParseException("Binary data is wrong dimension in latent liability model");
            }
            return new BinaryLatentLiabilityLikelihood(treeModel, patternList, compoundParameter);
        }

        @Override
        public String getParserDescription() {
            return "Provides the likelihood of a latent liability model on multivariate-binary trait data";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return BinaryLatentLiabilityLikelihood.class;
        }
    };
    private TreeModel treeModel;
    private PatternList patternList;
    private CompoundParameter tipTraitParameter;
    private boolean[][] tipData;
    private boolean likelihoodKnown = false;
    private double logLikelihood;
    private double storedLogLikelihood;
    private static final boolean DEBUG = false;
    private double pathParameter = 1.0;

    public BinaryLatentLiabilityLikelihood(TreeModel treeModel, PatternList patternList, CompoundParameter compoundParameter) {
        super(LATENT_LIABILITY_LIKELIHOOD);
        this.treeModel = treeModel;
        this.patternList = patternList;
        this.tipTraitParameter = compoundParameter;
        this.addVariable(compoundParameter);
        this.setTipDataValuesForAllNodes();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Constructing a latent liability likelihood model:\n");
        stringBuilder.append("\tBinary patterns: ").append(patternList.getId()).append("\n");
        stringBuilder.append("\tPlease cite:\n").append(Citable.Utils.getCitationString(this));
        Logger.getLogger("dr.evomodel.continous").info(stringBuilder.toString());
    }

    private void setTipDataValuesForAllNodes() {
        if (this.tipData == null) {
            this.tipData = new boolean[this.treeModel.getExternalNodeCount()][this.patternList.getPatternCount()];
        }
        for (int i = 0; i < this.treeModel.getExternalNodeCount(); ++i) {
            NodeRef nodeRef = this.treeModel.getExternalNode(i);
            String string = this.treeModel.getTaxonId(i);
            int n = this.patternList.getTaxonIndex(string);
            System.err.println("\t For node: " + i + " with ID " + string + " you get taxon " + n + " with ID " + this.patternList.getTaxonId(n));
            System.err.println("taxon: " + string + ", index: " + n);
            this.setTipDataValuesForNode(nodeRef, n);
        }
    }

    private void setTipDataValuesForNode(NodeRef nodeRef, int n) {
        int n2 = nodeRef.getNumber();
        if (n2 != n) {
            throw new RuntimeException("Need to figure out the indexing");
        }
        for (int i = 0; i < this.patternList.getPatternCount(); ++i) {
            this.tipData[n2][i] = this.patternList.getPattern(i)[n2] == 1;
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        this.logLikelihood = this.storedLogLikelihood;
        this.likelihoodKnown = true;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.computeLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(" + this.getLogLikelihood() + ")";
    }

    protected double computeLogLikelihood() {
        boolean bl = true;
        for (int i = 0; i < this.tipData.length && bl; ++i) {
            bl = this.validTraitForTip(i);
        }
        if (bl) {
            return 0.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public boolean validTraitForTip(int n) {
        boolean bl = true;
        Parameter parameter = this.tipTraitParameter.getParameter(n);
        boolean[] blArray = this.tipData[n];
        for (int i = 0; i < blArray.length && bl; ++i) {
            boolean bl2 = blArray[i];
            double d = parameter.getParameterValue(i);
            boolean bl3 = d > 0.0;
            bl = bl2 == bl3;
        }
        return bl;
    }

    @Override
    public double getNormalizationConstant(Distribution distribution) {
        return this.normalizationDelegate.getNormalizationConstant(distribution);
    }

    @Override
    public void setPathParameter(double d) {
        this.pathParameter = d;
    }

    @Override
    public double getLikelihoodCorrection() {
        return 0.0;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TRAIT_MODELS;
    }

    @Override
    public String getDescription() {
        return "Latent Liability model";
    }

    @Override
    public List<Citation> getCitations() {
        ArrayList<Citation> arrayList = new ArrayList<Citation>();
        arrayList.add(CommonCitations.CYBIS_2015_ASSESSING);
        return arrayList;
    }
}

