/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic;

import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class DriftedLocationsStatistic
extends Statistic.Abstract
implements VariableListener {
    public static final String DRIFTED_LOCATIONS_STATISTIC = "driftedLocationsStatistic";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String LOCATIONS = "locations";
        public static final String OFFSETS = "offsets";
        public static final String LOCATION_DRIFT = "locationDrift";
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("locations", MatrixParameter.class), new ElementRule("offsets", Parameter.class), new ElementRule("locationDrift", Parameter.class)};

        @Override
        public String getParserName() {
            return DriftedLocationsStatistic.DRIFTED_LOCATIONS_STATISTIC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getElementFirstChild(LOCATIONS);
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(OFFSETS);
            Parameter parameter2 = (Parameter)xMLObject.getElementFirstChild(LOCATION_DRIFT);
            return new DriftedLocationsStatistic(matrixParameter, parameter, parameter2);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a statistic that shifts a matrix of locations by location drift in the first dimension.";
        }

        @Override
        public Class getReturnType() {
            return DriftedLocationsStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private MatrixParameter locationsParameter;
    private Parameter offsetsParameter;
    private Parameter locationDriftParameter;

    public DriftedLocationsStatistic(MatrixParameter matrixParameter, Parameter parameter, Parameter parameter2) {
        this.locationsParameter = matrixParameter;
        matrixParameter.addParameterListener(this);
        this.offsetsParameter = parameter;
        parameter.addParameterListener(this);
        this.locationDriftParameter = parameter2;
        parameter2.addParameterListener(this);
    }

    @Override
    public int getDimension() {
        return this.locationsParameter.getDimension();
    }

    public int getColumnIndex(int n) {
        return n / this.locationsParameter.getRowDimension();
    }

    public int getRowIndex(int n) {
        int n2 = this.getColumnIndex(n);
        return n - n2 * this.locationsParameter.getRowDimension();
    }

    @Override
    public double getStatisticValue(int n) {
        int n2 = this.getColumnIndex(n);
        int n3 = this.getRowIndex(n);
        Parameter parameter = this.locationsParameter.getParameter(n2);
        double d = n3 == 0 ? parameter.getParameterValue(n3) + this.locationDriftParameter.getParameterValue(0) * this.offsetsParameter.getParameterValue(n2) : parameter.getParameterValue(n3);
        return d;
    }

    @Override
    public String getDimensionName(int n) {
        return this.locationsParameter.getDimensionName(n);
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }
}

