/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution;

import dr.evolution.LinkageConstraints;
import dr.evolution.LinkedGroup;
import dr.evolution.alignment.Alignment;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxa;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.util.Attributable;
import dr.util.Identifiable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MetagenomeData
implements Attributable,
Identifiable {
    protected String id = null;
    protected Alignment alignment;
    protected Taxa referenceTaxa;
    protected Taxa reads;
    protected LinkageConstraints constraints;
    protected boolean fixedReferenceTree;
    private Attributable.AttributeHelper attributes = null;

    public MetagenomeData(TaxonList taxonList, Alignment alignment) {
        this(taxonList, alignment, null, false);
    }

    public MetagenomeData(TaxonList taxonList, Alignment alignment, LinkageConstraints linkageConstraints, boolean bl) {
        this.alignment = alignment;
        this.constraints = linkageConstraints;
        this.fixedReferenceTree = bl;
        this.referenceTaxa = new Taxa(taxonList.asList());
        if (bl && !(taxonList instanceof Tree)) {
            throw new RuntimeException("Error, a tree must be provided in order to fix the topology of reference taxa");
        }
        this.reads = new Taxa();
        List<Taxon> list = alignment.asList();
        for (int i = 0; i < list.size(); ++i) {
            if (this.referenceTaxa.contains(list.get(i))) continue;
            this.reads.addTaxon(list.get(i));
        }
        if (linkageConstraints == null) {
            this.constraints = new LinkageConstraints(new ArrayList<LinkedGroup>());
        }
    }

    public TaxonList getReferenceTaxa() {
        return this.referenceTaxa;
    }

    public TaxonList getReadsTaxa() {
        return this.reads;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public ArrayList<LinkedGroup> getConstraints() {
        return this.constraints.getLinkedGroups();
    }

    public boolean getFixedReferenceTree() {
        return this.fixedReferenceTree;
    }

    public void setFixedReferenceTree(boolean bl) {
        this.fixedReferenceTree = bl;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new Attributable.AttributeHelper();
        }
        this.attributes.setAttribute(string, object);
    }

    @Override
    public Object getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(string);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttributeNames();
    }
}

