/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.preorder;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.treedatalikelihood.continuous.ConjugateRootTraitPrior;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousRateTransformation;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.evomodel.treedatalikelihood.preorder.TipFullConditionalDistributionDelegate;
import dr.inference.model.MatrixParameterInterface;

public class TipGradientViaFullConditionalDelegate
extends TipFullConditionalDistributionDelegate {
    public TipGradientViaFullConditionalDelegate(String string, MutableTreeModel mutableTreeModel, MultivariateDiffusionModel multivariateDiffusionModel, ContinuousTraitPartialsProvider continuousTraitPartialsProvider, ConjugateRootTraitPrior conjugateRootTraitPrior, ContinuousRateTransformation continuousRateTransformation, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate) {
        super(string, mutableTreeModel, multivariateDiffusionModel, continuousTraitPartialsProvider, conjugateRootTraitPrior, continuousRateTransformation, continuousDataLikelihoodDelegate);
    }

    public static String getName(String string) {
        return "grad." + string;
    }

    @Override
    public String getTraitName(String string) {
        return TipGradientViaFullConditionalDelegate.getName(string);
    }

    @Override
    protected double[] getTraitForNode(NodeRef nodeRef) {
        if (this.likelihoodDelegate.getPrecisionType() != PrecisionType.SCALAR) {
            throw new RuntimeException("Tip gradients are not implemented for '" + this.likelihoodDelegate.getPrecisionType().toString() + "' likelihoods");
        }
        double[] dArray = super.getTraitForNode(nodeRef);
        double[] dArray2 = new double[this.dimPartial * this.numTraits];
        this.cdi.getPostOrderPartial(this.likelihoodDelegate.getActiveNodeIndex(nodeRef.getNumber()), dArray2);
        MatrixParameterInterface matrixParameterInterface = this.diffusionModel.getPrecisionParameter();
        double[] dArray3 = new double[this.dimTrait * this.numTraits];
        if (this.numTraits > 1) {
            throw new RuntimeException("Not yet implemented");
        }
        double d = dArray[this.dimTrait];
        for (int i = 0; i < this.dimTrait; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.dimTrait; ++j) {
                d2 += (dArray[j] - dArray2[j]) * d * matrixParameterInterface.getParameterValue(i, j);
            }
            dArray3[i] = d2;
        }
        return dArray3;
    }
}

